                <div class="card">
                    <div class="card-header" style="flex-direction: column; align-items: flex-start;">
                        <div style="width: 100%; display: flex; justify-content: space-between; align-items: flex-start; margin-bottom: 15px;">
                            <div>
                                <h2 class="card-title">Laporan Rekapitulasi</h2>
                                <p class="card-subtitle"><?php echo $reportTitle ?? 'Ringkasan Data Produksi'; ?></p>
                            </div>
                            <div style="display: flex; gap: 10px;">
                                 <?php 
                                    $exportParams = $_GET;
                                    $exportParams['export'] = 'report_excel';
                                    $excelUrl = 'dashboard.php?' . http_build_query($exportParams);
                                 ?>
                                 <a href="<?php echo $excelUrl; ?>" class="btn btn-success" target="_blank">
                                    <i class="fas fa-file-excel"></i> Excel
                                </a>
                                <button id="exportReportPdf" class="btn btn-danger">
                                    <i class="fas fa-file-pdf"></i> PDF
                                </button>
                            </div>
                        </div>

                        <form method="GET" action="dashboard.php" style="width: 100%; background: #f8f9fa; padding: 15px; border-radius: 8px;">
                            <input type="hidden" name="tab" value="report">
                            <div style="display: flex; gap: 15px; flex-wrap: wrap; align-items: flex-end;">
                                <div class="form-group" style="margin: 0;">
                                    <label class="form-label" style="font-size: 12px;">Periode</label>
                                    <select name="filter_type" id="filter_type" class="form-control" onchange="toggleFilters()" style="min-width: 150px;">
                                        <option value="yearly" <?php echo $filterType == 'yearly' ? 'selected' : ''; ?>>Tahunan</option>
                                        <option value="quarterly" <?php echo $filterType == 'quarterly' ? 'selected' : ''; ?>>Triwulan</option>
                                        <option value="monthly" <?php echo $filterType == 'monthly' ? 'selected' : ''; ?>>Bulanan</option>
                                        <option value="weekly" <?php echo $filterType == 'weekly' ? 'selected' : ''; ?>>Mingguan</option>
                                    </select>
                                </div>

                                <div class="form-group filter-item" id="filter_year" style="margin: 0;">
                                    <label class="form-label" style="font-size: 12px;">Tahun</label>
                                    <select name="tahun" class="form-control" style="min-width: 100px;">
                                        <?php foreach ($years as $year): ?>
                                            <option value="<?php echo $year; ?>" <?php echo $selectedYear == $year ? 'selected' : ''; ?>><?php echo $year; ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>

                                <div class="form-group filter-item" id="filter_quarter" style="margin: 0; display: none;">
                                    <label class="form-label" style="font-size: 12px;">Triwulan</label>
                                    <select name="triwulan" class="form-control" style="min-width: 120px;">
                                        <option value="1" <?php echo $selectedQuarter == 1 ? 'selected' : ''; ?>>Triwulan I (Jan-Mar)</option>
                                        <option value="2" <?php echo $selectedQuarter == 2 ? 'selected' : ''; ?>>Triwulan II (Apr-Jun)</option>
                                        <option value="3" <?php echo $selectedQuarter == 3 ? 'selected' : ''; ?>>Triwulan III (Jul-Sep)</option>
                                        <option value="4" <?php echo $selectedQuarter == 4 ? 'selected' : ''; ?>>Triwulan IV (Okt-Des)</option>
                                    </select>
                                </div>

                                <div class="form-group filter-item" id="filter_month" style="margin: 0; display: none;">
                                    <label class="form-label" style="font-size: 12px;">Bulan</label>
                                    <select name="bulan" class="form-control" style="min-width: 120px;">
                                        <?php
                                        $months = [1=>'Januari', 'Februari', 'Maret', 'April', 'Mei', 'Juni', 'Juli', 'Agustus', 'September', 'Oktober', 'November', 'Desember'];
                                        foreach ($months as $num => $name): ?>
                                            <option value="<?php echo $num; ?>" <?php echo $selectedMonth == $num ? 'selected' : ''; ?>><?php echo $name; ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>

                                <div class="form-group filter-item" id="filter_week" style="margin: 0; display: none;">
                                    <label class="form-label" style="font-size: 12px;">Tanggal (Minggu)</label>
                                    <input type="date" name="week_date" class="form-control" value="<?php echo $selectedDate; ?>">
                                    <small style="font-size: 10px; color: #666; display: block;">Pilih tanggal dalam minggu</small>
                                </div>

                                <button type="submit" class="btn btn-primary" style="height: 38px;">
                                    <i class="fas fa-filter"></i> Terapkan
                                </button>
                            </div>
                        </form>
                    </div>

                    <div class="table-container">
                        <table>
                            <thead>
                                <tr>
                                    <th>Tanaman</th>
                                    <th>Total Luas Lahan</th>
                                    <th>Total Luas Panen</th>
                                    <th>Total Produksi</th>
                                    <th>Satuan</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if (empty($reportData)): ?>
                                    <tr>
                                        <td colspan="5" style="text-align: center; padding: 40px; color: var(--text-light);">
                                            Belum ada data terverifikasi
                                        </td>
                                    </tr>
                                <?php else: ?>
                                    <?php foreach ($reportData as $row): ?>
                                        <tr>
                                            <td><?php echo htmlspecialchars($row['nama_tanaman']); ?></td>
                                            <td><?php echo (strpos($row['total_lahan'], '.') !== false ? rtrim(rtrim($row['total_lahan'], '0'), '.') : $row['total_lahan']); ?> Ha</td>
                                            <td><?php echo (strpos($row['total_panen'], '.') !== false ? rtrim(rtrim($row['total_panen'], '0'), '.') : $row['total_panen']); ?> Ha</td>
                                            <td><?php echo (strpos($row['total_produksi'], '.') !== false ? rtrim(rtrim($row['total_produksi'], '0'), '.') : $row['total_produksi']); ?></td>
                                            <td><?php echo htmlspecialchars($row['satuan_produksi']); ?></td>
                                        </tr>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            </tbody>
                        </table>

                        <!-- Pagination -->
                        <?php if (isset($totalRows) && $totalRows > 0): ?>
                        <div style="margin-top: 20px; display: flex; justify-content: space-between; align-items: center; padding: 0 10px;">
                            <div style="font-size: 0.9em; color: #666;">
                                Menampilkan <?php echo count($reportData); ?> data dari total <?php echo $totalRows; ?> data
                            </div>
                            <div class="pagination" style="display: flex; gap: 5px; align-items: center;">
                                <?php if ($page > 1): ?>
                                    <a href="<?php echo updateParams(['page' => $page - 1]); ?>" class="btn btn-sm btn-secondary" style="padding: 5px 10px; font-size: 12px;">&laquo; Prev</a>
                                <?php endif; ?>
                                
                                <span style="padding: 5px 10px; background: #f1f1f1; border-radius: 4px; font-size: 0.9em;">Halaman <?php echo $page; ?> dari <?php echo $totalPages; ?></span>

                                <?php if ($page < $totalPages): ?>
                                    <a href="<?php echo updateParams(['page' => $page + 1]); ?>" class="btn btn-sm btn-secondary" style="padding: 5px 10px; font-size: 12px;">Next &raquo;</a>
                                <?php endif; ?>
                            </div>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>

                <!-- jsPDF CDN -->
                <script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
                <!-- jsPDF AutoTable CDN -->
                <script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf-autotable/3.5.31/jspdf.plugin.autotable.min.js"></script>

                <script>
                    function toggleFilters() {
                        const type = document.getElementById('filter_type').value;
                        const q = document.getElementById('filter_quarter');
                        const m = document.getElementById('filter_month');
                        const w = document.getElementById('filter_week');
                        
                        if(q) q.style.display = (type === 'quarterly') ? 'block' : 'none';
                        if(m) m.style.display = (type === 'monthly') ? 'block' : 'none';
                        if(w) w.style.display = (type === 'weekly') ? 'block' : 'none';
                    }

                    document.addEventListener('DOMContentLoaded', function() {
                        toggleFilters();

                        document.getElementById('exportReportPdf').addEventListener('click', function() {
                            const { jsPDF } = window.jspdf;
                            const doc = new jsPDF();

                            // Title
                            doc.setFontSize(16);
                            doc.text('Laporan Rekapitulasi Produksi', 14, 15);
                            doc.setFontSize(12);
                            doc.text('<?php echo $reportTitle ?? ""; ?>', 14, 22);
                            doc.setFontSize(10);
                            doc.text('Dicetak pada: ' + new Date().toLocaleString('id-ID'), 14, 28);

                            // Data
                            const data = <?php
                                $pdfData = array_map(function($row) {
                                    return [
                                        $row['nama_tanaman'],
                                        number_format($row['total_lahan'], 2) . ' Ha',
                                        number_format($row['total_panen'], 2) . ' Ha',
                                        number_format($row['total_produksi'], 2),
                                        $row['satuan_produksi']
                                    ];
                                }, $allReportData);
                                echo json_encode($pdfData);
                            ?>;

                            doc.autoTable({
                                head: [['Tanaman', 'Total Luas Lahan', 'Total Luas Panen', 'Total Produksi', 'Satuan']],
                                body: data,
                                startY: 35,
                                theme: 'grid',
                                headStyles: { fillColor: [22, 163, 74] },
                                styles: { fontSize: 10 },
                                columnStyles: {
                                    1: { halign: 'right' },
                                    2: { halign: 'right' },
                                    3: { halign: 'right' }
                                }
                            });

                            doc.save('laporan_rekapitulasi_<?php echo $selectedYear; ?>.pdf');
                        });
                    });
                </script>