                <div class="dashboard-grid">
                    <?php if ($isAdmin): ?>
                    <div class="stat-card">
                        <div>
                            <div class="stat-value"><?php echo $stats['users']; ?></div>
                            <div class="stat-label">Total Pengguna</div>
                        </div>
                        <div class="stat-icon users">
                            <i class="fas fa-users"></i>
                        </div>
                    </div>
                    <?php endif; ?>

                    <div class="stat-card">
                        <div>
                            <div class="stat-value"><?php echo $stats['regions']; ?></div>
                            <div class="stat-label">Wilayah</div>
                        </div>
                        <div class="stat-icon regions">
                            <i class="fas fa-map-marker-alt"></i>
                        </div>
                    </div>

                    <div class="stat-card">
                        <div>
                            <div class="stat-value"><?php echo $stats['production']; ?></div>
                            <div class="stat-label">Data Produksi</div>
                        </div>
                        <div class="stat-icon production">
                            <i class="fas fa-database"></i>
                        </div>
                    </div>
                </div>

                <div class="info-panels">
                    <?php if ($isAdmin): ?>
                    <div class="info-panel">
                        <h3 class="info-panel-title">Informasi Pengguna</h3>
                        <p class="info-panel-subtitle">Detail akun Anda</p>
                        <div class="info-item">
                            <div class="info-label">Username:</div>
                            <div class="info-value"><?php echo htmlspecialchars($currentUser['username']); ?></div>
                        </div>
                        <div class="info-item">
                            <div class="info-label">Email:</div>
                            <div class="info-value"><?php echo htmlspecialchars($currentUser['email']); ?></div>
                        </div>
                        <div class="info-item">
                            <div class="info-label">Jabatan:</div>
                            <div class="info-value">
                                <span class="badge badge-primary"><?php echo htmlspecialchars($currentUser['jabatan']); ?></span>
                            </div>
                        </div>
                    </div>
                    <?php endif; ?>

                    <div class="info-panel">
                        <h3 class="info-panel-title">Aksi Cepat</h3>
                        <p class="info-panel-subtitle">Navigasi ke modul utama</p>
                        <div class="quick-actions">
                            <?php if (!$isAdmin): ?>
                            <a href="dashboard.php?tab=produksi" class="btn btn-primary">
                                Input Data Produksi
                            </a>
                            <?php endif; ?>

                            <?php if ($isAdmin): ?>
                            <a href="dashboard.php?tab=produksi" class="btn btn-primary">
                                Data Akhir Produksi
                            </a>
                            <a href="dashboard.php?tab=report" class="btn btn-secondary">
                                Report
                            </a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

                <!-- Annual Recap & Monthly Chart -->
                <div class="dashboard-grid" style="grid-template-columns: 1fr 2fr; margin-top: 20px; gap: 20px;">
                    <!-- Annual Recap Table -->
                    <div class="info-panel">
                        <h3 class="info-panel-title">Rekapitulasi Pertahun</h3>
                        <p class="info-panel-subtitle">Total produksi per tahun</p>
                        <div class="table-container" style="margin-top: 15px;">
                            <table style="width: 100%;">
                                <thead>
                                    <tr>
                                        <th style="text-align: left; padding: 8px; border-bottom: 1px solid #eee;">Tahun</th>
                                        <th style="text-align: right; padding: 8px; border-bottom: 1px solid #eee;">Total Produksi</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php if (empty($annualRecap)): ?>
                                    <tr>
                                        <td colspan="2" style="text-align: center; padding: 10px;">Belum ada data</td>
                                    </tr>
                                    <?php else: ?>
                                        <?php foreach ($annualRecap as $recap): ?>
                                        <tr>
                                            <td style="padding: 8px; border-bottom: 1px solid #f9f9f9;"><?php echo $recap['tahun_produksi']; ?></td>
                                            <td style="text-align: right; padding: 8px; border-bottom: 1px solid #f9f9f9;"><?php echo number_format($recap['total_produksi'], 2); ?></td>
                                        </tr>
                                        <?php endforeach; ?>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>

                    <!-- Monthly Chart -->
                    <div class="info-panel">
                        <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 15px;">
                            <div>
                                <h3 class="info-panel-title">Grafik Produksi Bulanan</h3>
                                <p class="info-panel-subtitle">Data Tahun <?php echo $selectedYear; ?></p>
                            </div>
                            <div style="display: flex; gap: 10px; align-items: center;">
                                <form method="GET" action="dashboard.php" style="margin: 0;">
                                    <input type="hidden" name="tab" value="overview">
                                    <select name="tahun" class="form-control" onchange="this.form.submit()" style="padding: 6px; border-radius: 4px; border: 1px solid #ddd;">
                                        <?php foreach ($availableYears as $year): ?>
                                            <option value="<?php echo $year; ?>" <?php echo $selectedYear == $year ? 'selected' : ''; ?>>
                                                <?php echo $year; ?>
                                            </option>
                                        <?php endforeach; ?>
                                        <?php if (empty($availableYears)): ?>
                                            <option value="<?php echo date('Y'); ?>"><?php echo date('Y'); ?></option>
                                        <?php endif; ?>
                                    </select>
                                </form>
                                <a href="dashboard.php?export=overview_excel&tahun=<?php echo $selectedYear; ?>" class="btn btn-sm btn-success" target="_blank" title="Export Excel" style="padding: 6px 12px; display: inline-flex; align-items: center; gap: 5px;">
                                    <i class="fas fa-file-excel"></i> Excel
                                </a>
                                <button id="exportPdfBtn" class="btn btn-sm btn-danger" title="Export PDF" style="padding: 6px 12px; display: inline-flex; align-items: center; gap: 5px; cursor: pointer;">
                                    <i class="fas fa-file-pdf"></i> PDF
                                </button>
                            </div>
                        </div>
                        <canvas id="monthlyChart" width="400" height="200"></canvas>
                    </div>
                </div>

                <!-- Comparison Chart -->
                <div class="info-panel" style="margin-top: 20px;">
                    <div style="margin-bottom: 15px;">
                        <h3 class="info-panel-title">Grafik Perbandingan Produksi Bulanan</h3>
                        <p class="info-panel-subtitle">Perbandingan Tahun <?php echo $selectedYear; ?> vs <?php echo $previousYear; ?></p>
                    </div>
                    <canvas id="comparisonChart" width="400" height="150"></canvas>
                </div>


                <!-- Chart.js CDN -->
                <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
                <!-- jsPDF CDN -->
                <script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
                <!-- jsPDF AutoTable CDN -->
                <script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf-autotable/3.5.31/jspdf.plugin.autotable.min.js"></script>

                <script>
                    document.addEventListener('DOMContentLoaded', function() {
                        console.log('Dashboard Overview Loaded');

                        // Data from PHP
                        const monthlyLabels = <?php echo json_encode($monthlyLabels); ?>;
                        const monthlyValues = <?php echo json_encode($monthlyValues); ?>;
                        const monthlyValuesPrev = <?php echo isset($monthlyValuesPrev) ? json_encode($monthlyValuesPrev) : '[]'; ?>;
                        const selectedYear = '<?php echo $selectedYear; ?>';
                        const previousYear = '<?php echo $previousYear; ?>';

                        // Check if Chart.js is loaded
                        if (typeof Chart === 'undefined') {
                            console.error('Chart.js library is not loaded!');
                            // Optional: Display error on screen
                            const chartContainer = document.getElementById('monthlyChart').parentElement;
                            if (chartContainer) {
                                chartContainer.innerHTML += '<p style="color:red; text-align:center;">Gagal memuat pustaka grafik. Periksa koneksi internet Anda.</p>';
                            }
                        } else {
                            // Monthly Chart (Original)
                            const canvasMonthly = document.getElementById('monthlyChart');
                            if (canvasMonthly) {
                                const ctxMonthly = canvasMonthly.getContext('2d');
                                new Chart(ctxMonthly, {
                                    type: 'line',
                                    data: {
                                        labels: monthlyLabels,
                                        datasets: [{
                                            label: 'Total Produksi (' + selectedYear + ')',
                                            data: monthlyValues,
                                            backgroundColor: 'rgba(34, 197, 94, 0.2)',
                                            borderColor: 'rgba(34, 197, 94, 1)',
                                            borderWidth: 2,
                                            tension: 0.3,
                                            fill: true
                                        }]
                                    },
                                    options: {
                                        responsive: true,
                                        plugins: {
                                            legend: {
                                                position: 'top',
                                            }
                                        },
                                        scales: {
                                            y: {
                                                beginAtZero: true,
                                                grid: {
                                                    color: '#f3f4f6'
                                                }
                                            },
                                            x: {
                                                grid: {
                                                    display: false
                                                }
                                            }
                                        }
                                    }
                                });
                            } else {
                                console.error('Canvas monthlyChart not found');
                            }

                            // Comparison Chart (New)
                            const canvasComparison = document.getElementById('comparisonChart');
                            if (canvasComparison) {
                                const ctxComparison = canvasComparison.getContext('2d');
                                new Chart(ctxComparison, {
                                    type: 'line',
                                    data: {
                                        labels: monthlyLabels,
                                        datasets: [{
                                            label: 'Tahun ' + selectedYear,
                                            data: monthlyValues,
                                            backgroundColor: 'rgba(34, 197, 94, 0.5)',
                                            borderColor: 'rgba(34, 197, 94, 1)',
                                            borderWidth: 2,
                                            tension: 0.3,
                                            fill: false
                                        },
                                        {
                                            label: 'Tahun ' + previousYear,
                                            data: monthlyValuesPrev,
                                            backgroundColor: 'rgba(107, 114, 128, 0.5)',
                                            borderColor: 'rgba(107, 114, 128, 1)',
                                            borderWidth: 2,
                                            borderDash: [5, 5],
                                            tension: 0.3,
                                            fill: false
                                        }]
                                    },
                                    options: {
                                        responsive: true,
                                        interaction: {
                                            mode: 'index',
                                            intersect: false,
                                        },
                                        plugins: {
                                            legend: {
                                                position: 'top',
                                            },
                                            tooltip: {
                                                callbacks: {
                                                    label: function(context) {
                                                        let label = context.dataset.label || '';
                                                        if (label) {
                                                            label += ': ';
                                                        }
                                                        if (context.parsed.y !== null) {
                                                            label += context.parsed.y.toLocaleString('id-ID');
                                                        }
                                                        return label;
                                                    }
                                                }
                                            }
                                        },
                                        scales: {
                                            y: {
                                                beginAtZero: true,
                                                grid: {
                                                    color: '#f3f4f6'
                                                }
                                            },
                                            x: {
                                                grid: {
                                                    display: false
                                                }
                                            }
                                        }
                                    }
                                });
                            } else {
                                console.error('Canvas comparisonChart not found');
                            }
                        }

                        // Handle PDF Export
                        const exportPdfBtn = document.getElementById('exportPdfBtn');
                        if (exportPdfBtn) {
                            exportPdfBtn.addEventListener('click', function() {
                                const { jsPDF } = window.jspdf;
                                const doc = new jsPDF('p', 'mm', 'a4'); // Portrait orientation for better table fit
                                
                                // 1. Add Title and Date
                                doc.setFontSize(16);
                                doc.text('Laporan Produksi Bulanan - Tahun ' + selectedYear, 105, 15, { align: 'center' });
                                doc.setFontSize(10);
                                doc.text('Dicetak pada: ' + new Date().toLocaleString('id-ID'), 105, 22, { align: 'center' });

                                // 2. Add Chart Image
                                const chartCanvas = document.getElementById('monthlyChart');
                                let startY = 30;
                                
                                if (chartCanvas) {
                                    // Create a temporary white background canvas
                                    const tempCanvas = document.createElement('canvas');
                                    tempCanvas.width = chartCanvas.width;
                                    tempCanvas.height = chartCanvas.height;
                                    const tempCtx = tempCanvas.getContext('2d');
                                    tempCtx.fillStyle = '#ffffff';
                                    tempCtx.fillRect(0, 0, tempCanvas.width, tempCanvas.height);
                                    tempCtx.drawImage(chartCanvas, 0, 0);
                                    
                                    const chartImg = tempCanvas.toDataURL('image/png');
                                    const imgProps = doc.getImageProperties(chartImg);
                                    const pdfWidth = doc.internal.pageSize.getWidth() - 30; // 15mm margin each side
                                    const pdfHeight = (imgProps.height * pdfWidth) / imgProps.width;
                                    
                                    doc.addImage(chartImg, 'PNG', 15, startY, pdfWidth, pdfHeight);
                                    startY += pdfHeight + 10;
                                }

                                // 3. Add Table Data
                                // Format data for AutoTable
                                const tableBody = monthlyLabels.map((month, index) => {
                                    return [month, parseFloat(monthlyValues[index]).toLocaleString('id-ID', {minimumFractionDigits: 2})];
                                });

                                // Calculate total
                                const totalProduction = monthlyValues.reduce((a, b) => a + parseFloat(b), 0);
                                tableBody.push(['TOTAL', totalProduction.toLocaleString('id-ID', {minimumFractionDigits: 2})]);

                                doc.autoTable({
                                    head: [['Bulan', 'Total Produksi']],
                                    body: tableBody,
                                    startY: startY,
                                    theme: 'grid',
                                    headStyles: { fillColor: [22, 163, 74] }, // Green header to match theme
                                    columnStyles: {
                                        0: { cellWidth: 'auto' },
                                        1: { halign: 'right' }
                                    },
                                    didParseCell: function (data) {
                                        // Make Total row bold
                                        if (data.row.index === tableBody.length - 1) {
                                            data.cell.styles.fontStyle = 'bold';
                                        }
                                    }
                                });
                                
                                doc.save('laporan_produksi_' + selectedYear + '.pdf');
                            });
                        }
                    });
                </script>
