<?php
// Logic for Report Tab
if ($activeTab == 'report') {
    // Get available years
    $yearQuery = "SELECT DISTINCT tahun_produksi FROM data_produksi ORDER BY tahun_produksi DESC";
    $yearResult = $conn->query($yearQuery);
    $years = [];
    while ($row = $yearResult->fetch_assoc()) {
        $years[] = $row['tahun_produksi'];
    }
    if (empty($years)) $years[] = date('Y');

    // Get Filter Parameters
    $filterType = $_GET['filter_type'] ?? 'yearly';
    $selectedYear = isset($_GET['tahun']) ? intval($_GET['tahun']) : (count($years) > 0 ? $years[0] : date('Y'));
    $selectedQuarter = isset($_GET['triwulan']) ? intval($_GET['triwulan']) : 1;
    $selectedMonth = isset($_GET['bulan']) ? intval($_GET['bulan']) : date('n');
    $selectedDate = isset($_GET['week_date']) ? $_GET['week_date'] : date('Y-m-d');
    
    // Pagination Parameters
    $limit = 10;
    $page = isset($_GET['page']) ? max(1, intval($_GET['page'])) : 1;
    $offset = ($page - 1) * $limit;

    // Build Query Conditions
    $whereClause = "WHERE dp.status = 'Verified'";
    $params = [];
    $types = "";
    
    // Filter Logic
    if ($filterType == 'yearly') {
        $whereClause .= " AND dp.tahun_produksi = ?";
        $params[] = $selectedYear;
        $types .= "i";
        $reportTitle = "Laporan Tahun $selectedYear";
    } 
    elseif ($filterType == 'quarterly') {
        $whereClause .= " AND dp.tahun_produksi = ?";
        $params[] = $selectedYear;
        $types .= "i";
        
        $startMonth = ($selectedQuarter - 1) * 3 + 1;
        $endMonth = $startMonth + 2;
        
        $whereClause .= " AND dp.bulan_produksi BETWEEN ? AND ?";
        $params[] = $startMonth;
        $params[] = $endMonth;
        $types .= "ii";
        
        $reportTitle = "Laporan Triwulan $selectedQuarter Tahun $selectedYear";
    }
    elseif ($filterType == 'monthly') {
        $whereClause .= " AND dp.tahun_produksi = ? AND dp.bulan_produksi = ?";
        $params[] = $selectedYear;
        $params[] = $selectedMonth;
        $types .= "ii";
        
        $monthName = date('F', mktime(0, 0, 0, $selectedMonth, 10));
        $reportTitle = "Laporan Bulan $monthName $selectedYear";
    }
    elseif ($filterType == 'weekly') {
        // For weekly, we assume filtering by created_at date range (Week of the selected date)
        // Or if data_produksi has exact dates. Since it only has month/year, 
        // we will filter by created_at for the specific week.
        $weekStart = date('Y-m-d 00:00:00', strtotime('monday this week', strtotime($selectedDate)));
        $weekEnd = date('Y-m-d 23:59:59', strtotime('sunday this week', strtotime($selectedDate)));
        
        $whereClause .= " AND dp.created_at BETWEEN ? AND ?";
        $params[] = $weekStart;
        $params[] = $weekEnd;
        $types .= "ss";
        
        $reportTitle = "Laporan Minggu (" . date('d M', strtotime($weekStart)) . " - " . date('d M', strtotime($weekEnd)) . ")";
    }

    // Main Query (Without Limit for Export/Total Count)
    $reportQuery = "SELECT t.nama_tanaman, t.satuan_produksi, 
                           SUM(dp.luas_lahan) as total_lahan,
                           SUM(dp.luas_panen) as total_panen,
                           SUM(dp.jumlah_produksi) as total_produksi
                    FROM data_produksi dp
                    JOIN tanaman t ON dp.tanaman_id = t.id
                    $whereClause
                    GROUP BY t.id, t.nama_tanaman, t.satuan_produksi
                    ORDER BY total_produksi DESC";
    
    $stmt = $conn->prepare($reportQuery);
    if (!empty($params)) {
        $stmt->bind_param($types, ...$params);
    }
    $stmt->execute();
    $reportResult = $stmt->get_result();
    
    $allReportData = [];
    while ($row = $reportResult->fetch_assoc()) {
        $allReportData[] = $row;
    }
    $stmt->close();

    // Pagination Logic (Array Slice)
    $totalRows = count($allReportData);
    $totalPages = ceil($totalRows / $limit);
    $reportData = array_slice($allReportData, $offset, $limit);

    // Helper to update URL params for pagination
    function updateParams($newParams = []) {
        $params = $_GET;
        foreach ($newParams as $key => $value) {
            $params[$key] = $value;
        }
        return 'dashboard.php?' . http_build_query($params);
    }
}
?>