<?php
// Logic for Overview Tab
if ($activeTab == 'overview') {
    // Get statistics for overview
    $stats = [];

    // Total Users
    $result = $conn->query("SELECT COUNT(*) as total FROM users");
    $stats['users'] = $result->fetch_assoc()['total'];

    // Total Plants
    $result = $conn->query("SELECT COUNT(*) as total FROM tanaman");
    $stats['plants'] = $result->fetch_assoc()['total'];

    // Total Regions
    $result = $conn->query("SELECT COUNT(*) as total FROM wilayah");
    $stats['regions'] = $result->fetch_assoc()['total'];

    // Total Production Data
    $result = $conn->query("SELECT COUNT(*) as total FROM data_produksi");
    $stats['production'] = $result->fetch_assoc()['total'];

    // Annual Recap Data
    $annualQuery = "SELECT tahun_produksi, SUM(jumlah_produksi) as total_produksi 
                    FROM data_produksi 
                    GROUP BY tahun_produksi 
                    ORDER BY tahun_produksi DESC";
    $annualResult = $conn->query($annualQuery);
    $annualRecap = [];
    $availableYears = [];
    while ($row = $annualResult->fetch_assoc()) {
        $annualRecap[] = $row;
        $availableYears[] = $row['tahun_produksi'];
    }

    // Selected Year for Monthly Chart
    $selectedYear = isset($_GET['tahun']) ? intval($_GET['tahun']) : (count($availableYears) > 0 ? $availableYears[0] : date('Y'));

    // Monthly Production Data for Selected Year
    $monthlyQuery = "SELECT bulan_produksi, SUM(jumlah_produksi) as total_produksi 
                     FROM data_produksi 
                     WHERE tahun_produksi = ? 
                     GROUP BY bulan_produksi 
                     ORDER BY bulan_produksi ASC";
    $stmt = $conn->prepare($monthlyQuery);
    $stmt->bind_param("i", $selectedYear);
    $stmt->execute();
    $monthlyResult = $stmt->get_result();
    
    // Initialize all 12 months with 0
    $monthlyData = array_fill(1, 12, 0);
    while ($row = $monthlyResult->fetch_assoc()) {
        $bulan = intval($row['bulan_produksi']);
        if ($bulan >= 1 && $bulan <= 12) {
            $monthlyData[$bulan] = (float)$row['total_produksi'];
        }
    }
    $stmt->close();

    // Monthly Production Data for Previous Year (Comparison)
    $previousYear = $selectedYear - 1;
    $stmt = $conn->prepare($monthlyQuery);
    $stmt->bind_param("i", $previousYear);
    $stmt->execute();
    $monthlyResultPrev = $stmt->get_result();
    
    // Initialize all 12 months with 0
    $monthlyDataPrev = array_fill(1, 12, 0);
    while ($row = $monthlyResultPrev->fetch_assoc()) {
        $bulan = intval($row['bulan_produksi']);
        if ($bulan >= 1 && $bulan <= 12) {
            $monthlyDataPrev[$bulan] = (float)$row['total_produksi'];
        }
    }
    $stmt->close();
    $monthlyValuesPrev = array_values($monthlyDataPrev);
    
    // Prepare Monthly Chart Data
    $monthlyLabels = ['Januari', 'Februari', 'Maret', 'April', 'Mei', 'Juni', 'Juli', 'Agustus', 'September', 'Oktober', 'November', 'Desember'];
    $monthlyValues = array_values($monthlyData);
}
?>