<?php
/**
 * Router for PHP Built-in Server
 * This file handles routing for the built-in PHP development server
 */

// Add current directory to include path
set_include_path(get_include_path() . PATH_SEPARATOR . __DIR__);

// Change to the directory where the script is located
chdir(__DIR__);

$requestUri = $_SERVER['REQUEST_URI'];
$requestPath = parse_url($requestUri, PHP_URL_PATH);

// Remove query string
$requestPath = strtok($requestPath, '?');

// If the file exists, serve it
if ($requestPath !== '/' && file_exists(__DIR__ . $requestPath)) {
    return false; // Serve the file as-is
}

// Handle root path
if ($requestPath === '/') {
    header('Location: login.php');
    return true;
}

// Handle PHP files
if (preg_match('/\.php$/', $requestPath)) {
    $filePath = __DIR__ . $requestPath;
    if (file_exists($filePath)) {
        require $filePath;
        return true;
    }
}

// Handle static files (CSS, JS, images)
if (preg_match('/\.(css|js|png|jpg|jpeg|gif|ico|svg|woff|woff2|ttf|eot)$/', $requestPath)) {
    return false; // Let the server handle it
}

// 404 - File not found
http_response_code(404);
echo "404 - File not found";
return true;

