                <!-- jsPDF CDN -->
                <script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
                <!-- jsPDF AutoTable CDN -->
                <script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf-autotable/3.5.31/jspdf.plugin.autotable.min.js"></script>

                <div class="card">
                    <div class="card-header" style="flex-direction: column; align-items: flex-start;">
                        <div style="width: 100%; display: flex; justify-content: space-between; align-items: flex-start; margin-bottom: 15px;">
                            <div>
                                <h2 class="card-title">Daftar Data Produksi</h2>
                                <p class="card-subtitle">Total: <?php echo $totalRows ?? count($data_produksi); ?> data produksi</p>
                            </div>
                            <div class="header-actions" style="display: flex; gap: 10px;">
                                <?php 
                                    $exportParams = $_GET;
                                    $exportParams['export'] = 'excel';
                                    $excelUrl = 'dashboard.php?' . http_build_query($exportParams);
                                ?>
                                <a href="<?php echo $excelUrl; ?>" class="btn btn-success" target="_blank" title="Export Excel">
                                    <i class="fas fa-file-excel"></i> Excel
                                </a>
                                <button id="exportProduksiPdf" class="btn btn-danger" title="Export PDF">
                                    <i class="fas fa-file-pdf"></i> PDF
                                </button>
                                <?php if ($editData): ?>
                                <a href="dashboard.php?tab=produksi" class="btn btn-secondary">
                                    <i class="fas fa-times"></i>
                                    Batal Edit
                                </a>
                                <?php else: ?>
                                <button class="btn btn-primary" onclick="openModal('modalTambahDataProduksi')">
                                    <i class="fas fa-plus"></i>
                                    Tambah Data Produksi
                                </button>
                                <?php endif; ?>
                            </div>
                        </div>

                        <form method="GET" action="dashboard.php" style="width: 100%; background: #f8f9fa; padding: 15px; border-radius: 8px;">
                            <input type="hidden" name="tab" value="produksi">
                            <div style="display: flex; gap: 15px; flex-wrap: wrap; align-items: flex-end;">
                                <div class="form-group" style="margin: 0;">
                                    <label class="form-label" style="font-size: 12px;">Periode</label>
                                    <select name="filter_type" id="filter_type" class="form-control" onchange="toggleFilters()" style="min-width: 150px;">
                                        <option value="all" <?php echo $filterType == 'all' ? 'selected' : ''; ?>>Semua</option>
                                        <option value="yearly" <?php echo $filterType == 'yearly' ? 'selected' : ''; ?>>Tahunan</option>
                                        <option value="quarterly" <?php echo $filterType == 'quarterly' ? 'selected' : ''; ?>>Triwulan</option>
                                        <option value="monthly" <?php echo $filterType == 'monthly' ? 'selected' : ''; ?>>Bulanan</option>
                                        <option value="weekly" <?php echo $filterType == 'weekly' ? 'selected' : ''; ?>>Mingguan</option>
                                    </select>
                                </div>

                                <div class="form-group filter-item" id="filter_year" style="margin: 0; display: none;">
                                    <label class="form-label" style="font-size: 12px;">Tahun</label>
                                    <select name="tahun" class="form-control" style="min-width: 100px;">
                                        <?php foreach ($years as $year): ?>
                                            <option value="<?php echo $year; ?>" <?php echo $selectedYear == $year ? 'selected' : ''; ?>><?php echo $year; ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>

                                <div class="form-group filter-item" id="filter_quarter" style="margin: 0; display: none;">
                                    <label class="form-label" style="font-size: 12px;">Triwulan</label>
                                    <select name="triwulan" class="form-control" style="min-width: 120px;">
                                        <option value="1" <?php echo $selectedQuarter == 1 ? 'selected' : ''; ?>>Triwulan I (Jan-Mar)</option>
                                        <option value="2" <?php echo $selectedQuarter == 2 ? 'selected' : ''; ?>>Triwulan II (Apr-Jun)</option>
                                        <option value="3" <?php echo $selectedQuarter == 3 ? 'selected' : ''; ?>>Triwulan III (Jul-Sep)</option>
                                        <option value="4" <?php echo $selectedQuarter == 4 ? 'selected' : ''; ?>>Triwulan IV (Okt-Des)</option>
                                    </select>
                                </div>

                                <div class="form-group filter-item" id="filter_month" style="margin: 0; display: none;">
                                    <label class="form-label" style="font-size: 12px;">Bulan</label>
                                    <select name="bulan" class="form-control" style="min-width: 120px;">
                                        <?php
                                        $months = [1=>'Januari', 'Februari', 'Maret', 'April', 'Mei', 'Juni', 'Juli', 'Agustus', 'September', 'Oktober', 'November', 'Desember'];
                                        foreach ($months as $num => $name): ?>
                                            <option value="<?php echo $num; ?>" <?php echo $selectedMonth == $num ? 'selected' : ''; ?>><?php echo $name; ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>

                                <div class="form-group filter-item" id="filter_week" style="margin: 0; display: none;">
                                    <label class="form-label" style="font-size: 12px;">Tanggal (Minggu)</label>
                                    <input type="date" name="week_date" class="form-control" value="<?php echo $selectedDate; ?>">
                                </div>

                                <button type="submit" class="btn btn-primary" style="height: 38px;">
                                    <i class="fas fa-filter"></i> Terapkan
                                </button>
                            </div>
                        </form>
                    </div>

                    <div class="table-container">
                        <table>
                            <thead>
                                <tr>
                                    <th>Tanaman</th>
                                    <th>Wilayah</th>
                                    <th>Luas Tanam</th>
                                    <th>Luas Panen</th>
                                    <th>Produksi</th>
                                    <th>Periode</th>
                                    <th>Petugas</th>
                                    <th>Status</th>
                                    <th>Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if (empty($data_produksi)): ?>
                                    <tr>
                                        <td colspan="9" style="text-align: center; padding: 40px; color: var(--text-light);">
                                            Tidak ada data produksi
                                        </td>
                                    </tr>
                                <?php else: ?>
                                    <?php foreach ($data_produksi as $dp): ?>
                                        <tr>
                                           <td><?php echo htmlspecialchars($dp['nama_tanaman']); ?></td>
                                           <td>
                                                <small class="text-muted">Desa</small> <?php echo htmlspecialchars($dp['desa']); ?><br>
                                                <small class="text-muted">Kec.</small> <?php echo htmlspecialchars($dp['kecamatan']); ?><br>
                                                <small class="text-muted">Kab.</small> <?php echo htmlspecialchars($dp['kabupaten']); ?>
                                           </td>
                                           <td><?php echo (strpos($dp['luas_lahan'], '.') !== false ? rtrim(rtrim($dp['luas_lahan'], '0'), '.') : $dp['luas_lahan']); ?> Ha</td>
                                            <td><?php echo (strpos($dp['luas_panen'], '.') !== false ? rtrim(rtrim($dp['luas_panen'], '0'), '.') : $dp['luas_panen']); ?> Ha</td>
                                            <td><?php echo (strpos($dp['jumlah_produksi'], '.') !== false ? rtrim(rtrim($dp['jumlah_produksi'], '0'), '.') : $dp['jumlah_produksi']); ?> <?php echo htmlspecialchars($dp['satuan_produksi']); ?></td>
                                            <td><?php echo $bulan[$dp['bulan_produksi']] . ' ' . $dp['tahun_produksi']; ?></td>
                                            <td><?php echo htmlspecialchars($dp['petugas_nama']); ?></td>
                                            <td>
                                                <?php if ($dp['status'] == 'Verified'): ?>
                                                    <span class="badge badge-success">
                                                        <i class="fas fa-check-circle"></i>
                                                        Verified
                                                    </span>
                                                <?php else: ?>
                                                    <span class="badge badge-warning">Pending</span>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <div class="action-buttons">
                                                    <?php if ($isAdmin && $dp['status'] == 'Pending'): ?>
                                                        <a href="dashboard.php?tab=produksi&verify=<?php echo $dp['id']; ?>" class="action-btn edit" title="Verifikasi">
                                                            <i class="fas fa-check"></i>
                                                        </a>
                                                    <?php endif; ?>
                                                    
                                                    <?php if ($isAdmin || ($dp['petugas_id'] == $_SESSION['user_id'] && $dp['status'] == 'Pending')): ?>
                                                    <a href="dashboard.php?tab=produksi&edit=<?php echo $dp['id']; ?>" class="action-btn edit">
                                                        <i class="fas fa-edit"></i>
                                                    </a>
                                                    <a href="dashboard.php?tab=produksi&delete=<?php echo $dp['id']; ?>" class="action-btn delete" onclick="return confirmDelete('Apakah Anda yakin ingin menghapus data produksi ini?')">
                                                        <i class="fas fa-trash"></i>
                                                    </a>
                                                    <?php endif; ?>
                                                </div>
                                            </td>
                                        </tr>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            </tbody>
                        </table>

                        <!-- Pagination -->
                        <?php if (isset($totalRows) && $totalRows > 0): ?>
                        <div style="margin-top: 20px; display: flex; justify-content: space-between; align-items: center; padding: 0 10px;">
                            <div style="font-size: 0.9em; color: #666;">
                                Menampilkan <?php echo count($data_produksi); ?> dari <?php echo $totalRows; ?> data
                            </div>
                            <div class="pagination" style="display: flex; gap: 5px; align-items: center;">
                                <?php if ($page > 1): ?>
                                    <a href="<?php echo updateParams(['page' => $page - 1]); ?>" class="btn btn-sm btn-secondary" style="padding: 5px 10px; font-size: 12px;">&laquo; Prev</a>
                                <?php endif; ?>
                                
                                <span style="padding: 5px 10px; background: #f1f1f1; border-radius: 4px; font-size: 0.9em;">Halaman <?php echo $page; ?> dari <?php echo $totalPages; ?></span>

                                <?php if ($page < $totalPages): ?>
                                    <a href="<?php echo updateParams(['page' => $page + 1]); ?>" class="btn btn-sm btn-secondary" style="padding: 5px 10px; font-size: 12px;">Next &raquo;</a>
                                <?php endif; ?>
                            </div>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>

                <!-- Modal Tambah/Edit Data Produksi -->
                <div id="modalTambahDataProduksi" class="modal-overlay">
                    <div class="modal">
                        <div class="modal-header">
                            <div>
                                <h3 class="modal-title"><?php echo $editData ? 'Edit Data Produksi' : 'Tambah Data Produksi'; ?></h3>
                                <p class="modal-subtitle"><?php echo $editData ? 'Edit data produksi' : 'Tambahkan data produksi baru'; ?></p>
                            </div>
                            <button class="modal-close" onclick="closeModal('modalTambahDataProduksi')">
                                <i class="fas fa-times"></i>
                            </button>
                        </div>
                        <form method="POST" action="dashboard.php?tab=produksi" id="formDataProduksi">

                <?php if ($editData): ?>
                                <input type="hidden" name="id" value="<?php echo $editData['id']; ?>">
                            <?php endif; ?>
                            <div class="modal-body">
                                <div class="form-group">
                                    <label class="form-label" for="tanaman_id">Tanaman</label>
                                    <select id="tanaman_id" name="tanaman_id" class="form-control" required>
                                        <option value="">Pilih tanaman</option>
                                        <?php foreach ($tanaman_list as $t): ?>
                                            <option value="<?php echo $t['id']; ?>" <?php echo ($editData && $editData['tanaman_id'] == $t['id']) ? 'selected' : ''; ?>>
                                                <?php echo htmlspecialchars($t['nama_tanaman']); ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                                <div class="form-group">
                                    <label class="form-label" for="filter_kabupaten">Kabupaten</label>
                                    <select id="filter_kabupaten" class="form-control">
                                        <option value="">Pilih Kabupaten</option>
                                    </select>
                                </div>
                                <div class="form-group">
                                    <label class="form-label" for="filter_kecamatan">Kecamatan</label>
                                    <select id="filter_kecamatan" class="form-control" disabled>
                                        <option value="">Pilih Kecamatan</option>
                                    </select>
                                </div>
                                <div class="form-group">
                                    <label class="form-label" for="filter_desa">Desa</label>
                                    <select id="filter_desa" class="form-control" disabled>
                                        <option value="">Pilih Desa</option>
                                    </select>
                                </div>
                                <input type="hidden" name="wilayah_id" id="wilayah_id" value="<?php echo $editData ? $editData['wilayah_id'] : ''; ?>" required>
                                <div class="form-group">
                                    <label class="form-label" for="luas_lahan">Luas Tanam (Ha)</label>
                                    <input type="number" id="luas_lahan" name="luas_lahan" class="form-control" step="any" value="<?php echo $editData ? htmlspecialchars($editData['luas_lahan']) : ''; ?>" placeholder="Contoh: 20.347362764236" required>
                                </div>
                                <div class="form-group">
                                    <label class="form-label" for="luas_panen">Luas Panen (Ha)</label>
                                    <input type="number" id="luas_panen" name="luas_panen" class="form-control" step="any" value="<?php echo $editData ? htmlspecialchars($editData['luas_panen']) : ''; ?>" placeholder="Contoh: 20.347362764236" required>
                                </div>
                                <div class="form-group">
                                    <label class="form-label" for="jumlah_produksi">Jumlah Produksi</label>
                                    <input type="number" id="jumlah_produksi" name="jumlah_produksi" class="form-control" step="any" value="<?php echo $editData ? htmlspecialchars($editData['jumlah_produksi']) : ''; ?>" placeholder="Contoh: 200.347362764236" required>
                                </div>
                                <div class="form-group">
                                    <label class="form-label" for="tahun_produksi">Tahun Produksi</label>
                                    <input type="number" id="tahun_produksi" name="tahun_produksi" class="form-control" min="2000" max="2100" value="<?php echo $editData ? htmlspecialchars($editData['tahun_produksi']) : date('Y'); ?>" required>
                                </div>
                                <div class="form-group">
                                    <label class="form-label" for="bulan_produksi">Bulan Produksi</label>
                                    <select id="bulan_produksi" name="bulan_produksi" class="form-control" required>
                                        <option value="">Pilih bulan</option>
                                        <?php foreach ($bulan as $num => $name): ?>
                                            <option value="<?php echo $num; ?>" <?php echo ($editData && $editData['bulan_produksi'] == $num) ? 'selected' : ''; ?>>
                                                <?php echo $name; ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                            </div>
                            <div class="modal-footer">
                                <button type="submit" class="btn btn-primary">Simpan</button>
                                <button type="button" class="btn btn-secondary" onclick="closeModal('modalTambahDataProduksi')">Batal</button>
                            </div>
                        </form>
                    </div>
                </div>

<script>
    // Define toggleFilters globally so it can be called from HTML attributes
    window.toggleFilters = function() {
        const filterTypeEl = document.getElementById('filter_type');
        if (!filterTypeEl) return;
        
        const filterType = filterTypeEl.value;
        
        const yearGroup = document.getElementById('filter_year');
        const quarterGroup = document.getElementById('filter_quarter');
        const monthGroup = document.getElementById('filter_month');
        const weekGroup = document.getElementById('filter_week');

        if (!yearGroup || !quarterGroup || !monthGroup || !weekGroup) return;
        
        // Hide all first
        yearGroup.style.display = 'none';
        quarterGroup.style.display = 'none';
        monthGroup.style.display = 'none';
        weekGroup.style.display = 'none';

        // Show based on selection
        if (filterType === 'yearly') {
            yearGroup.style.display = 'block';
        } else if (filterType === 'quarterly') {
            yearGroup.style.display = 'block';
            quarterGroup.style.display = 'block';
        } else if (filterType === 'monthly') {
            yearGroup.style.display = 'block';
            monthGroup.style.display = 'block';
        } else if (filterType === 'weekly') {
            weekGroup.style.display = 'block';
        }
    };

    document.addEventListener('DOMContentLoaded', function() {
        // Run toggleFilters initially
        window.toggleFilters();

        // PDF Export Logic
        const btnExportPdf = document.getElementById('exportProduksiPdf');
        if (btnExportPdf) {
            btnExportPdf.addEventListener('click', function() {
                const { jsPDF } = window.jspdf;
                const doc = new jsPDF('l', 'mm', 'a4'); // Landscape

                // Title
                doc.setFontSize(16);
                doc.text('Laporan Data Produksi', 14, 15);
                doc.setFontSize(10);
                doc.text('Dicetak pada: ' + new Date().toLocaleString('id-ID'), 14, 22);

                // Data Preparation
                const data = <?php 
                    $exportData = array_map(function($dp) use ($bulan) {
                        return [
                            $dp['nama_tanaman'],
                            $dp['desa'] . ', ' . $dp['kecamatan'] . ', ' . $dp['kabupaten'],
                            (strpos($dp['luas_lahan'], '.') !== false ? rtrim(rtrim($dp['luas_lahan'], '0'), '.') : $dp['luas_lahan']) . ' Ha',
                            (strpos($dp['luas_panen'], '.') !== false ? rtrim(rtrim($dp['luas_panen'], '0'), '.') : $dp['luas_panen']) . ' Ha',
                            (strpos($dp['jumlah_produksi'], '.') !== false ? rtrim(rtrim($dp['jumlah_produksi'], '0'), '.') : $dp['jumlah_produksi']) . ' ' . $dp['satuan_produksi'],
                            $bulan[$dp['bulan_produksi']] . ' ' . $dp['tahun_produksi'],
                            $dp['petugas_nama'],
                            $dp['status']
                        ];
                    }, $allDataProduksi);
                    echo json_encode($exportData); 
                ?>;

                doc.autoTable({
                    head: [['Tanaman', 'Wilayah', 'Luas Lahan', 'Luas Panen', 'Produksi', 'Periode', 'Petugas', 'Status']],
                    body: data,
                    startY: 30,
                    theme: 'grid',
                    headStyles: { fillColor: [22, 163, 74] },
                    styles: { fontSize: 8 },
                    columnStyles: {
                        0: { cellWidth: 25 },
                        1: { cellWidth: 40 },
                        2: { halign: 'right' },
                        3: { halign: 'right' },
                        4: { halign: 'right' }
                    }
                });

                doc.save('data_produksi.pdf');
            });
        }

        // Wilayah Logic for Modal
        const allWilayah = <?php echo json_encode($wilayah_list); ?>;
        const editWilayahId = "<?php echo $editData ? $editData['wilayah_id'] : ''; ?>";

        const kabSelect = document.getElementById('filter_kabupaten');
        const kecSelect = document.getElementById('filter_kecamatan');
        const desaSelect = document.getElementById('filter_desa');
        const wilayahIdInput = document.getElementById('wilayah_id');

        if (kabSelect && kecSelect && desaSelect && wilayahIdInput) {
            // Get Unique Kabupatens
            const kabupatens = [...new Set(allWilayah.map(w => w.kabupaten))].sort();
            kabupatens.forEach(kab => {
                const option = document.createElement('option');
                option.value = kab;
                option.textContent = kab;
                kabSelect.appendChild(option);
            });

            function populateKecamatan(kab) {
                kecSelect.innerHTML = '<option value="">Pilih Kecamatan</option>';
                kecSelect.disabled = !kab;
                desaSelect.innerHTML = '<option value="">Pilih Desa</option>';
                desaSelect.disabled = true;
                wilayahIdInput.value = '';

                if (!kab) return;

                const kecamatans = [...new Set(allWilayah.filter(w => w.kabupaten === kab).map(w => w.kecamatan))].sort();
                kecamatans.forEach(kec => {
                    const option = document.createElement('option');
                    option.value = kec;
                    option.textContent = kec;
                    kecSelect.appendChild(option);
                });
            }

            function populateDesa(kab, kec) {
                desaSelect.innerHTML = '<option value="">Pilih Desa</option>';
                desaSelect.disabled = !kec;
                wilayahIdInput.value = '';

                if (!kec) return;

                const desas = allWilayah.filter(w => w.kabupaten === kab && w.kecamatan === kec).sort((a, b) => a.desa.localeCompare(b.desa));
                desas.forEach(w => {
                    const option = document.createElement('option');
                    option.value = w.desa;
                    option.dataset.id = w.id;
                    option.textContent = w.desa;
                    desaSelect.appendChild(option);
                });
            }

            kabSelect.addEventListener('change', function() {
                populateKecamatan(this.value);
            });

            kecSelect.addEventListener('change', function() {
                populateDesa(kabSelect.value, this.value);
            });

            desaSelect.addEventListener('change', function() {
                const selectedOption = this.options[this.selectedIndex];
                if (selectedOption.value) {
                    wilayahIdInput.value = selectedOption.dataset.id;
                } else {
                    wilayahIdInput.value = '';
                }
            });

            // Handle Edit Mode
            if (editWilayahId) {
                const currentWilayah = allWilayah.find(w => w.id == editWilayahId);
                if (currentWilayah) {
                    kabSelect.value = currentWilayah.kabupaten;
                    populateKecamatan(currentWilayah.kabupaten);
                    
                    kecSelect.value = currentWilayah.kecamatan;
                    populateDesa(currentWilayah.kabupaten, currentWilayah.kecamatan);
                    
                    desaSelect.value = currentWilayah.desa;
                    wilayahIdInput.value = editWilayahId;
                }
                // Open modal automatically in edit mode
                if (window.openModal) {
                     window.openModal('modalTambahDataProduksi');
                }
            }
        }
    });
</script>
