<?php
// Logic for Produksi Tab
if ($activeTab == 'produksi') {
    // Ensure columns support high precision decimals
    try {
        $schema = DB_NAME;
        $checkSql = "SELECT COLUMN_NAME, DATA_TYPE, NUMERIC_PRECISION, NUMERIC_SCALE 
                     FROM INFORMATION_SCHEMA.COLUMNS 
                     WHERE TABLE_SCHEMA = ? AND TABLE_NAME = 'data_produksi' 
                       AND COLUMN_NAME IN ('luas_lahan','luas_panen','jumlah_produksi')";
        $stmt = $conn->prepare($checkSql);
        $stmt->bind_param("s", $schema);
        $stmt->execute();
        $res = $stmt->get_result();
        $needAlter = [];
        while ($col = $res->fetch_assoc()) {
            if ($col['DATA_TYPE'] !== 'decimal' || intval($col['NUMERIC_SCALE']) < 30 || intval($col['NUMERIC_PRECISION']) < 65) {
                $needAlter[] = $col['COLUMN_NAME'];
            }
        }
        $stmt->close();
        if (!empty($needAlter)) {
            $conn->query("ALTER TABLE data_produksi 
                          MODIFY COLUMN luas_lahan DECIMAL(65,30) NOT NULL,
                          MODIFY COLUMN luas_panen DECIMAL(65,30) NOT NULL,
                          MODIFY COLUMN jumlah_produksi DECIMAL(65,30) NOT NULL");
        }
    } catch (\Throwable $e) {
        // Silently ignore schema auto-upgrade errors
    }
    // Handle delete
    if (isset($_GET['delete']) && is_numeric($_GET['delete'])) {
        $id = intval($_GET['delete']);
        
        // Check permission
        if (!$isAdmin) {
            // Petugas can only delete their own PENDING data
            $stmt = $conn->prepare("SELECT petugas_id, status FROM data_produksi WHERE id = ?");
            $stmt->bind_param("i", $id);
            $stmt->execute();
            $res = $stmt->get_result();
            if ($row = $res->fetch_assoc()) {
                if ($row['petugas_id'] != $_SESSION['user_id'] || $row['status'] != 'Pending') {
                    // Unauthorized
                    header('Location: dashboard.php?tab=produksi&error=unauthorized');
                    exit();
                }
            } else {
                // Not found
                header('Location: dashboard.php?tab=produksi');
                exit();
            }
        }

        $stmt = $conn->prepare("DELETE FROM data_produksi WHERE id = ?");
        $stmt->bind_param("i", $id);
        $stmt->execute();
        $stmt->close();
        header('Location: dashboard.php?tab=produksi&success=delete');
        exit();
    }

    // Handle status update (Admin only)
    if (isset($_GET['verify']) && is_numeric($_GET['verify'])) {
        if (!$isAdmin) {
             header('Location: dashboard.php?tab=produksi');
             exit();
        }
        $id = intval($_GET['verify']);
        $stmt = $conn->prepare("UPDATE data_produksi SET status = 'Verified' WHERE id = ?");
        $stmt->bind_param("i", $id);
        $stmt->execute();
        $stmt->close();
        header('Location: dashboard.php?tab=produksi&success=verify');
        exit();
    }

    // Handle add/edit
    if ($_SERVER['REQUEST_METHOD'] == 'POST') {
        $id = $_POST['id'] ?? null;
        $tanaman_id = $_POST['tanaman_id'] ?? '';
        $wilayah_id = $_POST['wilayah_id'] ?? '';
        $luas_lahan = $_POST['luas_lahan'] ?? '';
        $luas_panen = $_POST['luas_panen'] ?? '';
        $jumlah_produksi = $_POST['jumlah_produksi'] ?? '';
        // Normalize decimal separators (accept comma or dot)
        $luas_lahan = str_replace(',', '.', $luas_lahan);
        $luas_panen = str_replace(',', '.', $luas_panen);
        $jumlah_produksi = str_replace(',', '.', $jumlah_produksi);
        $tahun_produksi = $_POST['tahun_produksi'] ?? '';
        $bulan_produksi = $_POST['bulan_produksi'] ?? '';

        if ($tanaman_id && $wilayah_id && $luas_lahan !== '' && $luas_panen !== '' && $jumlah_produksi !== '' && $tahun_produksi && $bulan_produksi) {
            $petugas_id = $_SESSION['user_id'];

            if ($id) {
                // Update
                // Check permission for update
                if (!$isAdmin) {
                    $stmt = $conn->prepare("SELECT petugas_id, status FROM data_produksi WHERE id = ?");
                    $stmt->bind_param("i", $id);
                    $stmt->execute();
                    $res = $stmt->get_result();
                    if ($row = $res->fetch_assoc()) {
                        if ($row['petugas_id'] != $_SESSION['user_id'] || $row['status'] != 'Pending') {
                             header('Location: dashboard.php?tab=produksi&error=unauthorized');
                             exit();
                        }
                    }
                }

                $stmt = $conn->prepare("UPDATE data_produksi SET tanaman_id = ?, wilayah_id = ?, luas_lahan = ?, luas_panen = ?, jumlah_produksi = ?, tahun_produksi = ?, bulan_produksi = ? WHERE id = ?");
                $stmt->bind_param("iisssiii", $tanaman_id, $wilayah_id, $luas_lahan, $luas_panen, $jumlah_produksi, $tahun_produksi, $bulan_produksi, $id);
            } else {
                // Insert
                $stmt = $conn->prepare("INSERT INTO data_produksi (tanaman_id, wilayah_id, luas_lahan, luas_panen, jumlah_produksi, tahun_produksi, bulan_produksi, petugas_id) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
                $stmt->bind_param("iisssiii", $tanaman_id, $wilayah_id, $luas_lahan, $luas_panen, $jumlah_produksi, $tahun_produksi, $bulan_produksi, $petugas_id);
            }
            $stmt->execute();
            $stmt->close();
            header('Location: dashboard.php?tab=produksi&success=' . ($id ? 'update' : 'add'));
            exit();
        }
    }

    // Get available years for filter
    $yearQuery = "SELECT DISTINCT tahun_produksi FROM data_produksi ORDER BY tahun_produksi DESC";
    $yearResult = $conn->query($yearQuery);
    $years = [];
    while ($row = $yearResult->fetch_assoc()) {
        $years[] = $row['tahun_produksi'];
    }
    if (empty($years)) $years[] = date('Y');

    // Get Filter Parameters
    $filterType = $_GET['filter_type'] ?? 'all';
    $selectedYear = isset($_GET['tahun']) ? intval($_GET['tahun']) : (count($years) > 0 ? $years[0] : date('Y'));
    $selectedQuarter = isset($_GET['triwulan']) ? intval($_GET['triwulan']) : 1;
    $selectedMonth = isset($_GET['bulan']) ? intval($_GET['bulan']) : date('n');
    $selectedDate = isset($_GET['week_date']) ? $_GET['week_date'] : date('Y-m-d');

    // Pagination Parameters
    $limit = 10;
    $page = isset($_GET['page']) ? max(1, intval($_GET['page'])) : 1;
    $offset = ($page - 1) * $limit;

    // Helper to update URL params
    function updateParams($newParams = []) {
        $params = $_GET;
        foreach ($newParams as $key => $value) {
            $params[$key] = $value;
        }
        return 'dashboard.php?' . http_build_query($params);
    }

    // Build Query
    $query = "SELECT dp.*, t.nama_tanaman, t.satuan_produksi, w.desa, w.kecamatan, w.kabupaten, u.nama_lengkap as petugas_nama
              FROM data_produksi dp
              LEFT JOIN tanaman t ON dp.tanaman_id = t.id
              LEFT JOIN wilayah w ON dp.wilayah_id = w.id
              LEFT JOIN users u ON dp.petugas_id = u.id";
    
    $whereClause = " WHERE 1=1";
    $params = [];
    $types = "";

    // Filter for non-admin
    if (!$isAdmin) {
        $whereClause .= " AND dp.petugas_id = ?";
        $params[] = $_SESSION['user_id'];
        $types .= "i";
    }

    // Apply Time Filters
    if ($filterType == 'yearly') {
        $whereClause .= " AND dp.tahun_produksi = ?";
        $params[] = $selectedYear;
        $types .= "i";
    } elseif ($filterType == 'quarterly') {
        $whereClause .= " AND dp.tahun_produksi = ?";
        $params[] = $selectedYear;
        $types .= "i";
        $startMonth = ($selectedQuarter - 1) * 3 + 1;
        $endMonth = $startMonth + 2;
        $whereClause .= " AND dp.bulan_produksi BETWEEN ? AND ?";
        $params[] = $startMonth;
        $params[] = $endMonth;
        $types .= "ii";
    } elseif ($filterType == 'monthly') {
        $whereClause .= " AND dp.tahun_produksi = ? AND dp.bulan_produksi = ?";
        $params[] = $selectedYear;
        $params[] = $selectedMonth;
        $types .= "ii";
    } elseif ($filterType == 'weekly') {
        $weekStart = date('Y-m-d 00:00:00', strtotime('monday this week', strtotime($selectedDate)));
        $weekEnd = date('Y-m-d 23:59:59', strtotime('sunday this week', strtotime($selectedDate)));
        $whereClause .= " AND dp.created_at BETWEEN ? AND ?";
        $params[] = $weekStart;
        $params[] = $weekEnd;
        $types .= "ss";
    }

    $query .= $whereClause . " ORDER BY dp.id DESC";

    // Get All Data (for PDF/Excel)
    $stmt = $conn->prepare($query);
    if (!empty($params)) {
        $stmt->bind_param($types, ...$params);
    }
    $stmt->execute();
    $result = $stmt->get_result();
    $allDataProduksi = [];
    while ($row = $result->fetch_assoc()) {
        $allDataProduksi[] = $row;
    }
    $stmt->close();

    // Pagination Logic
    $totalRows = count($allDataProduksi);
    $totalPages = ceil($totalRows / $limit);
    $data_produksi = array_slice($allDataProduksi, $offset, $limit);

    // Get production data for edit
    $editData = null;
    if (isset($_GET['edit']) && is_numeric($_GET['edit'])) {
        $editId = intval($_GET['edit']);
        $stmt = $conn->prepare("SELECT * FROM data_produksi WHERE id = ?");
        $stmt->bind_param("i", $editId);
        $stmt->execute();
        $result = $stmt->get_result();
        if ($result->num_rows > 0) {
            $editData = $result->fetch_assoc();
            // Check permission again for edit form
             if (!$isAdmin && ($editData['petugas_id'] != $_SESSION['user_id'] || $editData['status'] != 'Pending')) {
                $editData = null; // Don't show form
            }
        }
        $stmt->close();
    }

    // Get plants and regions for dropdowns
    $tanaman_result = $conn->query("SELECT * FROM tanaman ORDER BY nama_tanaman");
    $tanaman_list = [];
    while ($row = $tanaman_result->fetch_assoc()) {
        $tanaman_list[] = $row;
    }

    $wilayah_result = $conn->query("SELECT * FROM wilayah ORDER BY kecamatan");
    $wilayah_list = [];
    while ($row = $wilayah_result->fetch_assoc()) {
        $wilayah_list[] = $row;
    }

    // Month names
    $bulan = [
        1 => 'Januari', 2 => 'Februari', 3 => 'Maret', 4 => 'April',
        5 => 'Mei', 6 => 'Juni', 7 => 'Juli', 8 => 'Agustus',
        9 => 'September', 10 => 'Oktober', 11 => 'November', 12 => 'Desember'
    ];
}
?>
