<?php
session_start();
require_once 'config/database.php';
require_once 'config/auth.php';

// Redirect if already logged in
if (isset($_SESSION['user_id'])) {
    header('Location: dashboard.php');
    exit();
}

$message = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = trim($_POST['username'] ?? '');
    $password = $_POST['password'] ?? '';

    if (empty($username) || empty($password)) {
        $message = 'Username and password are required.';
    } else {
        $user = authenticate_user($username, $password);
        if ($user) {
            $_SESSION['user_id'] = $user['id'];
            $_SESSION['username'] = $user['username'];
            $_SESSION['nama_lengkap'] = $user['nama_lengkap'];
            $_SESSION['email'] = $user['email'];
            $_SESSION['jabatan'] = $user['jabatan'];
            header('Location: dashboard.php?success=login');
            exit();
        } else {
            $message = 'Invalid username or password.';
        }
    }
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - SIDAPBUN</title>
    <style>
* {
    margin: 0;
    padding: 0;
    box-sizing: border-box;
}

:root {
    --primary-color: #22c55e;
    --primary-dark: #16a34a;
    --dark-bg: #1f2937;
    --dark-sidebar: #111827;
    --light-bg: #f9fafb;
    --white: #ffffff;
    --text-dark: #1f2937;
    --text-light: #6b7280;
    --border-color: #e5e7eb;
    --success: #10b981;
    --danger: #ef4444;
}

body {
    font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    background: linear-gradient(135deg, #f0fdf4 0%, #fefce8 100%);
    min-height: 100vh;
}

.app-container {
    display: flex;
    min-height: 100vh;
}

/* Sidebar */
.sidebar {
    width: 280px;
    background: var(--white);
    display: flex;
    flex-direction: column;
    box-shadow: 2px 0 10px rgba(0, 0, 0, 0.1);
    position: fixed;
    height: 100vh;
    z-index: 1000;
}

.sidebar-header {
    padding: 24px 20px;
    border-bottom: 1px solid var(--border-color);
}

.logo {
    display: inline-flex;
    align-items: center;
    justify-content: center;
    width: 40px;
    height: 40px;
    background: var(--primary-color);
    border-radius: 50%;
    color: white;
    font-size: 20px;
    margin-bottom: 12px;
}

.logo-text h2 {
    font-size: 20px;
    font-weight: bold;
    color: var(--text-dark);
    margin-bottom: 4px;
}

.logo-text p {
    font-size: 12px;
    color: var(--text-light);
}

.sidebar-nav {
    flex: 1;
    padding: 20px 0;
    overflow-y: auto;
}

.nav-item {
    display: flex;
    align-items: center;
    padding: 12px 20px;
    color: var(--text-dark);
    text-decoration: none;
    transition: all 0.3s;
    margin: 4px 12px;
    border-radius: 8px;
}

.nav-item i {
    margin-right: 12px;
    width: 20px;
    text-align: center;
}

.nav-item:hover {
    background: var(--light-bg);
}

.nav-item.active {
    background: var(--primary-color);
    color: white;
}

.sidebar-footer {
    padding: 20px;
    border-top: 1px solid var(--border-color);
}

.user-profile {
    display: flex;
    align-items: center;
}

.user-avatar {
    width: 40px;
    height: 40px;
    border-radius: 50%;
    background: var(--light-bg);
    display: flex;
    align-items: center;
    justify-content: center;
    font-weight: bold;
    color: var(--text-dark);
    margin-right: 12px;
}

.user-name {
    font-weight: bold;
    color: var(--text-dark);
    font-size: 14px;
}

.user-role {
    font-size: 12px;
    color: var(--text-light);
}

/* Main Content */
.main-content {
    flex: 1;
    margin-left: 280px;
    padding: 32px;
    min-height: 100vh;
}

/* Top Header Bar */
.top-header-bar {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 24px;
    padding-bottom: 16px;
    border-bottom: 1px solid var(--border-color);
}

.top-header-actions {
    display: flex;
    align-items: center;
    gap: 12px;
}

.btn-logout {
    display: inline-flex;
    align-items: center;
    gap: 8px;
    padding: 10px 20px;
    background: var(--danger);
    color: white;
    border-radius: 8px;
    text-decoration: none;
    font-size: 14px;
    font-weight: 500;
    transition: all 0.3s;
    cursor: pointer;
}

.btn-logout:hover {
    background: #dc2626;
    transform: translateY(-1px);
    box-shadow: 0 4px 8px rgba(239, 68, 68, 0.3);
}

.page-header {
    margin-bottom: 32px;
}

.page-title {
    font-size: 32px;
    font-weight: bold;
    color: var(--text-dark);
    margin-bottom: 8px;
}

.page-subtitle {
    font-size: 16px;
    color: var(--text-light);
}

/* Cards */
.card {
    background: var(--white);
    border-radius: 12px;
    padding: 24px;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
    margin-bottom: 24px;
}

.card-header {
    display: flex;
    justify-content: space-between;
    align-items: flex-start;
    margin-bottom: 24px;
}

.card-title {
    font-size: 20px;
    font-weight: bold;
    color: var(--text-dark);
    margin-bottom: 8px;
}

.card-subtitle {
    font-size: 14px;
    color: var(--text-light);
}

.btn {
    padding: 10px 20px;
    border: none;
    border-radius: 8px;
    font-size: 14px;
    font-weight: 500;
    cursor: pointer;
    transition: all 0.3s;
    text-decoration: none;
    display: inline-flex;
    align-items: center;
    gap: 8px;
}

.btn-primary {
    background: var(--primary-color);
    color: white;
}

.btn-primary:hover {
    background: var(--primary-dark);
}

.btn-secondary {
    background: var(--white);
    color: var(--text-dark);
    border: 1px solid var(--border-color);
}

.btn-secondary:hover {
    background: var(--light-bg);
}

.btn-danger {
    background: var(--danger);
    color: white;
}

.btn-danger:hover {
    background: #dc2626;
}

/* Tables */
.table-container {
    overflow-x: auto;
}

table {
    width: 100%;
    border-collapse: collapse;
}

thead {
    background: var(--light-bg);
}

th {
    padding: 12px 16px;
    text-align: left;
    font-weight: 600;
    color: var(--text-dark);
    font-size: 14px;
    border-bottom: 2px solid var(--border-color);
}

td {
    padding: 16px;
    border-bottom: 1px solid var(--border-color);
    color: var(--text-dark);
    font-size: 14px;
}

tbody tr:hover {
    background: var(--light-bg);
}

.badge {
    display: inline-flex;
    align-items: center;
    gap: 6px;
    padding: 4px 12px;
    border-radius: 20px;
    font-size: 12px;
    font-weight: 500;
}

.badge-success {
    background: #d1fae5;
    color: #065f46;
}

.badge-warning {
    background: #fef3c7;
    color: #92400e;
}

.badge-primary {
    background: #dbeafe;
    color: #1e40af;
}

.action-buttons {
    display: flex;
    gap: 8px;
}

.action-btn {
    width: 32px;
    height: 32px;
    border: none;
    border-radius: 6px;
    cursor: pointer;
    display: flex;
    align-items: center;
    justify-content: center;
    transition: all 0.3s;
    background: transparent;
    color: var(--text-light);
}

.action-btn:hover {
    background: var(--light-bg);
    color: var(--text-dark);
}

.action-btn.edit:hover {
    color: var(--primary-color);
}

.action-btn.delete:hover {
    color: var(--danger);
}

/* Modal */
.modal-overlay {
    display: none;
    position: fixed;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: rgba(0, 0, 0, 0.5);
    z-index: 2000;
    align-items: center;
    justify-content: center;
}

.modal-overlay.active {
    display: flex;
}

.modal {
    background: var(--white);
    border-radius: 12px;
    width: 90%;
    max-width: 600px;
    max-height: 90vh;
    overflow-y: auto;
    box-shadow: 0 10px 40px rgba(0, 0, 0, 0.2);
    position: relative;
}

.modal-header {
    padding: 24px;
    border-bottom: 1px solid var(--border-color);
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.modal-title {
    font-size: 24px;
    font-weight: bold;
    color: var(--text-dark);
    margin-bottom: 4px;
}

.modal-subtitle {
    font-size: 14px;
    color: var(--text-light);
}

.modal-close {
    width: 32px;
    height: 32px;
    border: none;
    background: transparent;
    cursor: pointer;
    font-size: 20px;
    color: var(--text-light);
    border-radius: 6px;
    transition: all 0.3s;
}

.modal-close:hover {
    background: var(--light-bg);
    color: var(--text-dark);
}

.modal-body {
    padding: 24px;
}

.modal-footer {
    padding: 24px;
    border-top: 1px solid var(--border-color);
    display: flex;
    gap: 12px;
    justify-content: flex-end;
}

/* Forms */
.form-group {
    margin-bottom: 20px;
}

.form-label {
    display: block;
    margin-bottom: 8px;
    font-weight: 500;
    color: var(--text-dark);
    font-size: 14px;
}

.form-control {
    width: 100%;
    padding: 10px 12px;
    border: 1px solid var(--border-color);
    border-radius: 8px;
    font-size: 14px;
    transition: all 0.3s;
    font-family: inherit;
}

.form-control:focus {
    outline: none;
    border-color: var(--primary-color);
    box-shadow: 0 0 0 3px rgba(34, 197, 94, 0.1);
}

select.form-control {
    cursor: pointer;
}

/* Toast Notification */
.toast {
    position: fixed;
    top: 24px;
    right: 24px;
    background: var(--success);
    color: white;
    padding: 12px 20px;
    border-radius: 8px;
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
    display: flex;
    align-items: center;
    gap: 12px;
    z-index: 3000;
    animation: slideIn 0.3s ease;
}

@keyframes slideIn {
    from {
        transform: translateX(100%);
        opacity: 0;
    }
    to {
        transform: translateX(0);
        opacity: 1;
    }
}

/* Dashboard */
.dashboard-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
    gap: 24px;
    margin-bottom: 32px;
}

.stat-card {
    background: var(--white);
    border-radius: 12px;
    padding: 24px;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.stat-value {
    font-size: 32px;
    font-weight: bold;
    color: var(--text-dark);
    margin-bottom: 4px;
}

.stat-label {
    font-size: 14px;
    color: var(--text-light);
}

.stat-icon {
    width: 60px;
    height: 60px;
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 24px;
    color: white;
}

.stat-icon.users {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
}

.stat-icon.plants {
    background: linear-gradient(135deg, var(--primary-color) 0%, var(--primary-dark) 100%);
}

.stat-icon.regions {
    background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);
}

.stat-icon.production {
    background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%);
}

.info-panels {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(400px, 1fr));
    gap: 24px;
}

.info-panel {
    background: var(--white);
    border-radius: 12px;
    padding: 24px;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
}

.info-panel-title {
    font-size: 18px;
    font-weight: bold;
    color: var(--text-dark);
    margin-bottom: 8px;
}

.info-panel-subtitle {
    font-size: 14px;
    color: var(--text-light);
    margin-bottom: 20px;
}

.info-item {
    margin-bottom: 16px;
}

.info-label {
    font-size: 12px;
    color: var(--text-light);
    margin-bottom: 4px;
}

.info-value {
    font-size: 14px;
    color: var(--text-dark);
    font-weight: 500;
}

.quick-actions {
    display: flex;
    flex-direction: column;
    gap: 12px;
}

/* Login/Register Pages */
.auth-container {
    min-height: 100vh;
    display: flex;
    align-items: center;
    justify-content: center;
    padding: 20px;
    background: linear-gradient(135deg, #f0fdf4 0%, #fefce8 100%);
}

.auth-card {
    background: var(--white);
    border-radius: 16px;
    padding: 40px;
    width: 100%;
    max-width: 450px;
    box-shadow: 0 10px 40px rgba(0, 0, 0, 0.1);
}

.auth-logo {
    text-align: center;
    margin-bottom: 32px;
}

.auth-logo-icon {
    width: 60px;
    height: 60px;
    background: var(--primary-color);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto 16px;
    color: white;
    font-size: 28px;
}

.auth-title {
    font-size: 28px;
    font-weight: bold;
    color: var(--text-dark);
    text-align: center;
    margin-bottom: 8px;
}

.auth-subtitle {
    font-size: 14px;
    color: var(--text-light);
    text-align: center;
    margin-bottom: 32px;
    text-align: center;
}

.auth-link {
    text-align: center;
    margin-top: 24px;
    font-size: 14px;
    color: var(--text-light);
}

.auth-link a {
    color: var(--primary-color);
    text-decoration: none;
    font-weight: 500;
}

.auth-link a:hover {
    text-decoration: underline;
}

/* Footer Brand */
.footer-brand {
    position: fixed;
    bottom: 16px;
    right: 16px;
    background: var(--text-dark);
    color: white;
    padding: 8px 12px;
    border-radius: 6px;
    font-size: 12px;
    display: flex;
    align-items: center;
    gap: 6px;
    z-index: 100;
}

/* Welcome Message */
.welcome-message {
    font-size: 16px;
    color: var(--text-light);
    margin-bottom: 24px;
}

.welcome-message strong {
    color: var(--primary-color);
}

/* Responsive */
@media (max-width: 768px) {
    .sidebar {
        transform: translateX(-100%);
        transition: transform 0.3s;
    }

    .sidebar.active {
        transform: translateX(0);
    }

    .main-content {
        margin-left: 0;
        padding: 20px;
    }

    .dashboard-grid {
        grid-template-columns: 1fr;
    }

    .info-panels {
        grid-template-columns: 1fr;
    }
}
    </style>
</head>
<body>
    <div class="auth-container">
        <div class="auth-card">
            <div class="auth-logo">
                <div class="auth-logo-icon">
                    <i class="fas fa-leaf"></i>
                </div>
                <h1 class="auth-title">SIDAPBUN</h1>
                <p class="auth-subtitle">Sistem Input Data Produksi Perkebunan</p>
            </div>

            <h2 style="text-align: center; margin-bottom: 24px; color: #1f2937;">Login</h2>

            <?php if ($message): ?>
                <div style="background: #fee2e2; color: #991b1b; padding: 12px; border-radius: 8px; margin-bottom: 20px; font-size: 14px;">
                    <?php echo htmlspecialchars($message); ?>
                </div>
            <?php endif; ?>

            <form method="POST" action="">
                <div class="form-group">
                    <label for="username" style="display: block; margin-bottom: 8px; font-weight: 500; color: #1f2937;">Username:</label>
                    <input type="text" id="username" name="username" required style="width: 100%; padding: 12px; border: 1px solid #e5e7eb; border-radius: 8px; font-size: 14px;">
                </div>

                <div class="form-group">
                    <label for="password" style="display: block; margin-bottom: 8px; font-weight: 500; color: #1f2937;">Password:</label>
                    <input type="password" id="password" name="password" required style="width: 100%; padding: 12px; border: 1px solid #e5e7eb; border-radius: 8px; font-size: 14px;">
                </div>

                <button type="submit" style="width: 100%; padding: 12px; background: #22c55e; color: white; border: none; border-radius: 8px; font-size: 16px; font-weight: 500; cursor: pointer; margin-bottom: 16px;">Login</button>
            </form>

            <div style="text-align: center; margin-top: 24px;">
                <p style="font-size: 14px; color: #6b7280; margin-bottom: 8px;">Don't have an account? <a href="register.php" style="color: #22c55e; text-decoration: none; font-weight: 500;">Register here</a></p>
            </div>
        </div>
    </div>
</body>
</html>