<?php
// Handle export to Excel for Report (Summary)

// Get Filter Parameters
$filterType = $_GET['filter_type'] ?? 'yearly';
$selectedYear = isset($_GET['tahun']) ? intval($_GET['tahun']) : date('Y');
$selectedQuarter = isset($_GET['triwulan']) ? intval($_GET['triwulan']) : 1;
$selectedMonth = isset($_GET['bulan']) ? intval($_GET['bulan']) : date('n');
$selectedDate = isset($_GET['week_date']) ? $_GET['week_date'] : date('Y-m-d');

// Build Query Conditions
$whereClause = "WHERE dp.status = 'Verified'";
$params = [];
$types = "";
$filenameSuffix = $selectedYear;

// Filter Logic (Same as logic_report.php)
if ($filterType == 'yearly') {
    $whereClause .= " AND dp.tahun_produksi = ?";
    $params[] = $selectedYear;
    $types .= "i";
    $filenameSuffix = "Tahun_" . $selectedYear;
} 
elseif ($filterType == 'quarterly') {
    $whereClause .= " AND dp.tahun_produksi = ?";
    $params[] = $selectedYear;
    $types .= "i";
    
    $startMonth = ($selectedQuarter - 1) * 3 + 1;
    $endMonth = $startMonth + 2;
    
    $whereClause .= " AND dp.bulan_produksi BETWEEN ? AND ?";
    $params[] = $startMonth;
    $params[] = $endMonth;
    $types .= "ii";
    
    $filenameSuffix = "Triwulan_" . $selectedQuarter . "_" . $selectedYear;
}
elseif ($filterType == 'monthly') {
    $whereClause .= " AND dp.tahun_produksi = ? AND dp.bulan_produksi = ?";
    $params[] = $selectedYear;
    $params[] = $selectedMonth;
    $types .= "ii";
    
    $filenameSuffix = "Bulan_" . $selectedMonth . "_" . $selectedYear;
}
elseif ($filterType == 'weekly') {
    $weekStart = date('Y-m-d 00:00:00', strtotime('monday this week', strtotime($selectedDate)));
    $weekEnd = date('Y-m-d 23:59:59', strtotime('sunday this week', strtotime($selectedDate)));
    
    $whereClause .= " AND dp.created_at BETWEEN ? AND ?";
    $params[] = $weekStart;
    $params[] = $weekEnd;
    $types .= "ss";
    
    $filenameSuffix = "Mingguan_" . date('Ymd', strtotime($weekStart));
}

// Report Logic: Summary of Verified Data
$reportQuery = "SELECT t.nama_tanaman, t.satuan_produksi, 
                       SUM(dp.luas_lahan) as total_lahan,
                       SUM(dp.luas_panen) as total_panen,
                       SUM(dp.jumlah_produksi) as total_produksi
                FROM data_produksi dp
                JOIN tanaman t ON dp.tanaman_id = t.id
                $whereClause
                GROUP BY t.id, t.nama_tanaman, t.satuan_produksi
                ORDER BY total_produksi DESC";

$stmt = $conn->prepare($reportQuery);
if (!empty($params)) {
    $stmt->bind_param($types, ...$params);
}
$stmt->execute();
$reportResult = $stmt->get_result();

$reportData = [];
while ($row = $reportResult->fetch_assoc()) {
    $reportData[] = $row;
}
$stmt->close();

header('Content-Type: application/vnd.ms-excel');
header('Content-Disposition: attachment; filename="rekapitulasi_produksi_' . $filenameSuffix . '.xls"');
header('Pragma: no-cache');
header('Expires: 0');

// Output CSV data (Tab separated)
echo "Tanaman\tTotal Luas Lahan (Ha)\tTotal Luas Panen (Ha)\tTotal Produksi\tSatuan\n";

foreach ($reportData as $row) {
    echo htmlspecialchars($row['nama_tanaman']) . "\t";
    echo (strpos($row['total_lahan'], '.') !== false ? rtrim(rtrim($row['total_lahan'], '0'), '.') : $row['total_lahan']) . "\t";
    echo (strpos($row['total_panen'], '.') !== false ? rtrim(rtrim($row['total_panen'], '0'), '.') : $row['total_panen']) . "\t";
    echo (strpos($row['total_produksi'], '.') !== false ? rtrim(rtrim($row['total_produksi'], '0'), '.') : $row['total_produksi']) . "\t";
    echo htmlspecialchars($row['satuan_produksi']) . "\n";
}
exit();
?>