<?php
// Handle export to Excel for Overview Chart (Monthly Data)

// Determine selected year
$selectedYear = isset($_GET['tahun']) ? intval($_GET['tahun']) : date('Y');

// Monthly Production Data for Selected Year
$monthlyQuery = "SELECT bulan_produksi, SUM(jumlah_produksi) as total_produksi 
                 FROM data_produksi 
                 WHERE tahun_produksi = ? 
                 GROUP BY bulan_produksi 
                 ORDER BY bulan_produksi ASC";
$stmt = $conn->prepare($monthlyQuery);
$stmt->bind_param("i", $selectedYear);
$stmt->execute();
$monthlyResult = $stmt->get_result();

// Initialize all 12 months with 0
$monthlyData = array_fill(1, 12, 0);
while ($row = $monthlyResult->fetch_assoc()) {
    $monthlyData[$row['bulan_produksi']] = (float)$row['total_produksi'];
}
$stmt->close();

$bulanNames = [
    1 => 'Januari', 2 => 'Februari', 3 => 'Maret', 4 => 'April',
    5 => 'Mei', 6 => 'Juni', 7 => 'Juli', 8 => 'Agustus',
    9 => 'September', 10 => 'Oktober', 11 => 'November', 12 => 'Desember'
];

header('Content-Type: application/vnd.ms-excel');
header('Content-Disposition: attachment; filename="grafik_produksi_bulanan_' . $selectedYear . '_' . date('Y-m-d') . '.xls"');
header('Pragma: no-cache');
header('Expires: 0');

// Output CSV data (Tab separated)
echo "Bulan\tTotal Produksi\n";

foreach ($monthlyData as $bulanNum => $total) {
    echo $bulanNames[$bulanNum] . "\t";
    echo number_format($total, 2, '.', '') . "\n";
}
exit();
?>