<?php
// Handle export to Excel
// Get Filter Parameters
$filterType = $_GET['filter_type'] ?? 'all';
// For year, default to current year if not specified, similar to logic_produksi.php
// We don't query available years here to save performance, just rely on input or date
$selectedYear = isset($_GET['tahun']) ? intval($_GET['tahun']) : date('Y');
$selectedQuarter = isset($_GET['triwulan']) ? intval($_GET['triwulan']) : 1;
$selectedMonth = isset($_GET['bulan']) ? intval($_GET['bulan']) : date('n');
$selectedDate = isset($_GET['week_date']) ? $_GET['week_date'] : date('Y-m-d');

// Build Query
$query = "SELECT dp.*, t.nama_tanaman, t.satuan_produksi, w.kecamatan, w.kabupaten, u.nama_lengkap as petugas_nama
          FROM data_produksi dp
          LEFT JOIN tanaman t ON dp.tanaman_id = t.id
          LEFT JOIN wilayah w ON dp.wilayah_id = w.id
          LEFT JOIN users u ON dp.petugas_id = u.id";

$whereClause = " WHERE 1=1";
$params = [];
$types = "";

// Filter for non-admin
if (!$isAdmin) {
    $whereClause .= " AND dp.petugas_id = ?";
    $params[] = $_SESSION['user_id'];
    $types .= "i";
}

// Apply Time Filters
if ($filterType == 'yearly') {
    $whereClause .= " AND dp.tahun_produksi = ?";
    $params[] = $selectedYear;
    $types .= "i";
} elseif ($filterType == 'quarterly') {
    $whereClause .= " AND dp.tahun_produksi = ?";
    $params[] = $selectedYear;
    $types .= "i";
    $startMonth = ($selectedQuarter - 1) * 3 + 1;
    $endMonth = $startMonth + 2;
    $whereClause .= " AND dp.bulan_produksi BETWEEN ? AND ?";
    $params[] = $startMonth;
    $params[] = $endMonth;
    $types .= "ii";
} elseif ($filterType == 'monthly') {
    $whereClause .= " AND dp.tahun_produksi = ? AND dp.bulan_produksi = ?";
    $params[] = $selectedYear;
    $params[] = $selectedMonth;
    $types .= "ii";
} elseif ($filterType == 'weekly') {
    $weekStart = date('Y-m-d 00:00:00', strtotime('monday this week', strtotime($selectedDate)));
    $weekEnd = date('Y-m-d 23:59:59', strtotime('sunday this week', strtotime($selectedDate)));
    $whereClause .= " AND dp.created_at BETWEEN ? AND ?";
    $params[] = $weekStart;
    $params[] = $weekEnd;
    $types .= "ss";
}

$query .= $whereClause . " ORDER BY dp.id DESC";

$stmt = $conn->prepare($query);
if (!empty($params)) {
    $stmt->bind_param($types, ...$params);
}
$stmt->execute();
$result = $stmt->get_result();
$data_produksi = [];
while ($row = $result->fetch_assoc()) {
    $data_produksi[] = $row;
}
$stmt->close();

// Month names
$bulan = [
    1 => 'Januari', 2 => 'Februari', 3 => 'Maret', 4 => 'April',
    5 => 'Mei', 6 => 'Juni', 7 => 'Juli', 8 => 'Agustus',
    9 => 'September', 10 => 'Oktober', 11 => 'November', 12 => 'Desember'
];

header('Content-Type: application/vnd.ms-excel');
header('Content-Disposition: attachment; filename="data_produksi_' . date('Y-m-d') . '.xls"');
header('Pragma: no-cache');
header('Expires: 0');

// Output CSV data (Tab separated)
echo "Tanaman\tWilayah\tLuas Lahan (Ha)\tLuas Panen (Ha)\tJumlah Produksi\tPeriode\tPetugas\tStatus\n";

foreach ($data_produksi as $dp) {
    echo htmlspecialchars($dp['nama_tanaman']) . "\t";
    echo htmlspecialchars($dp['kecamatan'] . ' - ' . $dp['kabupaten']) . "\t";
    echo (strpos($dp['luas_lahan'], '.') !== false ? rtrim(rtrim($dp['luas_lahan'], '0'), '.') : $dp['luas_lahan']) . "\t";
    echo (strpos($dp['luas_panen'], '.') !== false ? rtrim(rtrim($dp['luas_panen'], '0'), '.') : $dp['luas_panen']) . "\t";
    echo (strpos($dp['jumlah_produksi'], '.') !== false ? rtrim(rtrim($dp['jumlah_produksi'], '0'), '.') : $dp['jumlah_produksi']) . " " . htmlspecialchars($dp['satuan_produksi']) . "\t";
    echo $bulan[$dp['bulan_produksi']] . ' ' . $dp['tahun_produksi'] . "\t";
    echo htmlspecialchars($dp['petugas_nama']) . "\t";
    echo $dp['status'] . "\n";
}
exit();
?>
