# Cara Import Database SIDAPBUN di XAMPP

## Metode 1: Menggunakan phpMyAdmin (Paling Mudah)

1. **Pastikan XAMPP sudah berjalan**
   - Buka XAMPP Control Panel
   - Start Apache dan MySQL

2. **Buka phpMyAdmin**
   - Buka browser dan akses: `http://localhost/phpmyadmin`

3. **Import Database**
   - Klik tab **"Import"** di bagian atas
   - Klik tombol **"Choose File"** atau **"Browse"**
   - Pilih file `database/schema.sql` dari folder project
   - Pastikan format file adalah **SQL**
   - Klik tombol **"Go"** atau **"Import"** di bagian bawah

4. **Verifikasi**
   - Di sidebar kiri, pastikan database `sidapbun` sudah muncul
   - Klik database `sidapbun` untuk melihat tabel-tabel yang sudah dibuat:
     - `users`
     - `tanaman`
     - `wilayah`
     - `data_produksi`

## Metode 2: Menggunakan Command Line (Windows)

1. **Buka Command Prompt atau PowerShell**
   - Tekan `Win + R`, ketik `cmd`, tekan Enter

2. **Masuk ke folder database**
   ```cmd
   cd C:\xampp\htdocs\sidapbun\sidapbun\database
   ```

3. **Import menggunakan MySQL**
   ```cmd
   C:\xampp\mysql\bin\mysql.exe -u root < schema.sql
   ```
   
   Jika MySQL memiliki password, gunakan:
   ```cmd
   C:\xampp\mysql\bin\mysql.exe -u root -p < schema.sql
   ```

## Metode 3: Menggunakan File Batch (Windows)

1. **Double-click file** `import_xampp.bat` di folder `database/`
2. File akan otomatis mengimport schema ke database

**Catatan:** Jika terjadi error, edit file `import_xampp.bat` dan sesuaikan path MySQL XAMPP Anda.

## Verifikasi Instalasi

Setelah import berhasil, verifikasi dengan:

1. **Cek Database**
   - Buka phpMyAdmin
   - Pastikan database `sidapbun` ada
   - Pastikan semua tabel sudah dibuat

2. **Cek User Default**
   - Buka tabel `users`
   - Pastikan ada user dengan username `admin_test`

3. **Test Login**
   - Buka aplikasi: `http://localhost/sidapbun/login.php`
   - Login dengan:
     - **Username:** `admin_test`
     - **Password:** `admin123`

## Troubleshooting

### Error: "Access denied for user 'root'"
- Pastikan MySQL di XAMPP sudah start
- Coba tanpa password (default XAMPP biasanya kosong)
- Jika ada password, gunakan: `mysql -u root -p`

### Error: "Database already exists"
- Tidak masalah, schema menggunakan `CREATE DATABASE IF NOT EXISTS`
- Tabel akan dibuat ulang jika belum ada

### Error: "Table already exists"
- Tidak masalah, schema menggunakan `CREATE TABLE IF NOT EXISTS`
- Data yang sudah ada tidak akan terhapus

### Error: "Foreign key constraint fails"
- Pastikan semua tabel dibuat dengan urutan yang benar
- Hapus database dan import ulang jika perlu:
  ```sql
  DROP DATABASE IF EXISTS sidapbun;
  ```
  Lalu import ulang schema.sql

## Struktur Database

Setelah import berhasil, database akan memiliki struktur:

- **users** - Tabel pengguna sistem
- **tanaman** - Tabel jenis tanaman
- **wilayah** - Tabel wilayah perkebunan
- **data_produksi** - Tabel data produksi perkebunan

## Kredensial Default

- **Username:** `admin_test`
- **Password:** `admin123`
- **Jabatan:** Admin

**PENTING:** Ubah password default setelah login pertama kali untuk keamanan!

php -S localhost:8000 router.php