<?php
require_once 'config/auth.php';
requireLogin();
$currentUser = getCurrentUser();
require_once 'config/database.php';

$conn = getDBConnection();

// Role checks
$isAdmin = ($currentUser['jabatan'] === 'Admin');
$isPetugas = ($currentUser['jabatan'] === 'Petugas Lapangan');

// Get active tab
$activeTab = $_GET['tab'] ?? 'overview';

// Handle Export
if (isset($_GET['export'])) {
    if ($_GET['export'] == 'excel') {
        require 'includes/export_excel.php';
    } elseif ($_GET['export'] == 'report_excel') {
        require 'includes/export_report_excel.php';
    } elseif ($_GET['export'] == 'overview_excel') {
        require 'includes/export_overview_excel.php';
    }
}

// Load Logic based on Tab
if ($activeTab == 'pengguna') {
    require 'admin/logic_pengguna.php';
} elseif ($activeTab == 'tanaman') {
    require 'admin/logic_tanaman.php';
} elseif ($activeTab == 'wilayah') {
    require 'admin/logic_wilayah.php';
} elseif ($activeTab == 'produksi') {
    require 'petugas/logic_produksi.php';
} elseif ($activeTab == 'report') {
    require 'views/logic_report.php';
} elseif ($activeTab == 'overview') {
    require 'views/logic_overview.php';
}

require_once 'includes/header.php';
?>
            <div class="page-header">
                <h1 class="page-title">Dashboard</h1>
                <?php if ($isPetugas): ?>
                <p class="welcome-message">Selamat datang, (<?php echo htmlspecialchars($currentUser['jabatan']); ?>)</p>
                <?php else: ?>
                <p class="welcome-message">Selamat datang, <strong><?php echo htmlspecialchars($currentUser['nama_lengkap']); ?></strong> (<?php echo htmlspecialchars($currentUser['jabatan']); ?>)</p>
                <?php endif; ?>
            </div>

            <?php if (isset($_GET['success'])): ?>
                <div class="toast">
                    <i class="fas fa-check-circle"></i>
                    <span>
                        <?php
                        if ($_GET['success'] == 'login') echo 'Login berhasil!';
                        elseif ($_GET['success'] == 'add') echo 'Data berhasil ditambahkan!';
                        elseif ($_GET['success'] == 'update') echo 'Data berhasil diperbarui!';
                        elseif ($_GET['success'] == 'delete') echo 'Data berhasil dihapus!';
                        elseif ($_GET['success'] == 'verify') echo 'Data berhasil diverifikasi!';
                        ?>
                    </span>
                </div>
            <?php endif; ?>
            
            <?php if (isset($_GET['error'])): ?>
                <div class="toast" style="background-color: var(--danger);">
                    <i class="fas fa-times-circle"></i>
                    <span>
                        <?php
                        if ($_GET['error'] == 'unauthorized') echo 'Anda tidak memiliki akses untuk melakukan tindakan ini.';
                        ?>
                    </span>
                </div>
            <?php endif; ?>

            <!-- Tab Navigation -->
            <div class="tab-navigation">
                <a href="dashboard.php?tab=overview" class="tab-link <?php echo $activeTab == 'overview' ? 'active' : ''; ?>">
                    <i class="fas fa-home"></i> Overview
                </a>

                <?php if ($isAdmin): ?>
                <a href="dashboard.php?tab=pengguna" class="tab-link <?php echo $activeTab == 'pengguna' ? 'active' : ''; ?>">
                    <i class="fas fa-users"></i> Pengguna
                </a>
                <a href="dashboard.php?tab=produksi" class="tab-link <?php echo $activeTab == 'produksi' ? 'active' : ''; ?>">
                    <i class="fas fa-database"></i> Data Akhir Produksi
                </a>
                <a href="dashboard.php?tab=report" class="tab-link <?php echo $activeTab == 'report' ? 'active' : ''; ?>">
                    <i class="fas fa-file-alt"></i> Report
                </a>
                <?php endif; ?>

                <?php if ($isPetugas): ?>
                <a href="dashboard.php?tab=tanaman" class="tab-link <?php echo $activeTab == 'tanaman' ? 'active' : ''; ?>">
                    <i class="fas fa-leaf"></i> Komoditi
                </a>
                <a href="dashboard.php?tab=wilayah" class="tab-link <?php echo $activeTab == 'wilayah' ? 'active' : ''; ?>">
                    <i class="fas fa-map-marker-alt"></i> Wilayah
                </a>
                <a href="dashboard.php?tab=produksi" class="tab-link <?php echo $activeTab == 'produksi' ? 'active' : ''; ?>">
                    <i class="fas fa-database"></i> Data Produksi
                </a>
                <?php endif; ?>
            </div>

            <!-- Tab Content -->
            <?php
            if ($activeTab == 'overview') {
                require 'views/view_overview.php';
            } elseif ($activeTab == 'pengguna' && $isAdmin) {
                require 'admin/view_pengguna.php';
            } elseif ($activeTab == 'tanaman') {
                require 'admin/view_tanaman.php';
            } elseif ($activeTab == 'wilayah') {
                require 'admin/view_wilayah.php';
            } elseif ($activeTab == 'produksi') {
                require 'petugas/view_produksi.php';
            } elseif ($activeTab == 'report') {
                require 'views/view_report.php';
            }
            ?>

            <script>
                function openModal(modalId) {
                    document.getElementById(modalId).classList.add('active');
                }

                function closeModal(modalId) {
                    document.getElementById(modalId).classList.remove('active');
                }

                function confirmDelete(message) {
                    return confirm(message);
                }

                // Close modal when clicking outside
                document.addEventListener('click', function(e) {
                    if (e.target.classList.contains('modal-overlay')) {
                        e.target.classList.remove('active');
                    }
                });
            </script>
<?php require_once 'includes/footer.php'; ?>