<?php
/**
 * Path Helper Functions
 * Untuk menangani base URL secara dinamis
 */

// Get base path dari script location
function getBasePath() {
    $scriptName = $_SERVER['SCRIPT_NAME'];
    $scriptDir = dirname($scriptName);
    
    // Jika di root, return /
    if ($scriptDir === '/' || $scriptDir === '\\') {
        return '/';
    }
    
    // Return dengan trailing slash
    return rtrim($scriptDir, '/') . '/';
}

// Get base URL (untuk redirect)
function baseUrl($path = '') {
    $base = getBasePath();
    $path = ltrim($path, '/');
    return $base . $path;
}

// Get asset URL
function assetUrl($path) {
    return baseUrl('assets/' . ltrim($path, '/'));
}
?>

