<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Check if user is logged in
function isLoggedIn() {
    return isset($_SESSION['user_id']);
}

// Require login
function requireLogin() {
    if (!isLoggedIn()) {
        header('Location: login.php');
        exit();
    }
}

// Get current user
function getCurrentUser() {
    if (!isLoggedIn()) {
        return null;
    }
    return $_SESSION;
}

// Logout
function logout() {
    session_destroy();
    header('Location: register.php');
    exit();
}
// Authenticate user
function authenticate_user($username, $password) {
    global $conn;
    if (!$conn) {
        $conn = getDBConnection();
    }

    $stmt = $conn->prepare("SELECT id, username, password, nama_lengkap, email, jabatan FROM users WHERE username = ?");
    $stmt->bind_param("s", $username);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows === 1) {
        $user = $result->fetch_assoc();
        if (password_verify($password, $user['password'])) {
            unset($user['password']); // Remove password from user data
            return $user;
        }
    }
    return false;
}
?>

