                <div class="card">
                    <div class="card-header">
                        <div>
                            <h2 class="card-title">Daftar Wilayah</h2>
                            <p class="card-subtitle">Total: <?php echo count($wilayah); ?> wilayah</p>
                        </div>
                        <?php if ($isAdmin || $isPetugas): ?>
                        <?php if (isset($_GET['edit'])): ?>
                        <a href="dashboard.php?tab=wilayah" class="btn btn-primary">
                            <i class="fas fa-plus"></i>
                            Tambah Wilayah
                        </a>
                        <?php else: ?>
                        <button class="btn btn-primary" onclick="openModal('modalTambahWilayah')">
                            <i class="fas fa-plus"></i>
                            Tambah Wilayah
                        </button>
                        <?php endif; ?>
                        <?php endif; ?>
                    </div>

                    <div class="table-container">
                        <table>
                            <thead>
                                <tr>
                                    <th>Desa</th>
                                    <th>Kecamatan</th>
                                    <th>Kabupaten</th>
                                    <?php if ($isAdmin || $isPetugas): ?>
                                    <th>Aksi</th>
                                    <?php endif; ?>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if (empty($wilayah)): ?>
                                    <tr>
                                        <td colspan="<?php echo ($isAdmin || $isPetugas) ? 4 : 3; ?>" style="text-align: center; padding: 40px; color: var(--text-light);">
                                            Tidak ada data wilayah
                                        </td>
                                    </tr>
                                <?php else: ?>
                                    <?php foreach ($wilayah as $w): ?>
                                        <tr>
                                            <td><?php echo htmlspecialchars($w['desa']); ?></td>
                                            <td><?php echo htmlspecialchars($w['kecamatan']); ?></td>
                                            <td><?php echo htmlspecialchars($w['kabupaten']); ?></td>
                                            <?php if ($isAdmin || $isPetugas): ?>
                                            <td>
                                                <div class="action-buttons">
                                                    <a href="dashboard.php?tab=wilayah&edit=<?php echo $w['id']; ?>" class="action-btn edit">
                                                        <i class="fas fa-edit"></i>
                                                    </a>
                                                    <a href="dashboard.php?tab=wilayah&delete=<?php echo $w['id']; ?>" class="action-btn delete" onclick="return confirmDelete('Apakah Anda yakin ingin menghapus wilayah ini?')">
                                                        <i class="fas fa-trash"></i>
                                                    </a>
                                                </div>
                                            </td>
                                            <?php endif; ?>
                                        </tr>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            </tbody>
                        </table>

                        <!-- Pagination -->
                        <?php if (isset($totalRows) && $totalRows > 0): ?>
                        <div style="margin-top: 20px; display: flex; justify-content: space-between; align-items: center; padding: 0 10px;">
                            <div style="font-size: 0.9em; color: #666;">
                                Menampilkan <?php echo count($wilayah); ?> dari <?php echo $totalRows; ?> data
                            </div>
                            <div class="pagination" style="display: flex; gap: 5px; align-items: center;">
                                <?php if ($page > 1): ?>
                                    <a href="dashboard.php?tab=wilayah&page=<?php echo $page - 1; ?>" class="btn btn-sm btn-secondary" style="padding: 5px 10px; font-size: 12px;">&laquo; Prev</a>
                                <?php endif; ?>
                                
                                <span style="padding: 5px 10px; background: #f1f1f1; border-radius: 4px; font-size: 0.9em;">Halaman <?php echo $page; ?> dari <?php echo $totalPages; ?></span>

                                <?php if ($page < $totalPages): ?>
                                    <a href="dashboard.php?tab=wilayah&page=<?php echo $page + 1; ?>" class="btn btn-sm btn-secondary" style="padding: 5px 10px; font-size: 12px;">Next &raquo;</a>
                                <?php endif; ?>
                            </div>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>

                <!-- Modal Tambah/Edit Wilayah -->
                <?php if ($isAdmin || $isPetugas): ?>
                <div id="modalTambahWilayah" class="modal-overlay">
                    <div class="modal">
                        <div class="modal-header">
                            <div>
                                <h3 class="modal-title"><?php echo $editWilayah ? 'Edit Wilayah' : 'Tambah Wilayah'; ?></h3>
                                <p class="modal-subtitle"><?php echo $editWilayah ? 'Edit data wilayah' : 'Tambahkan wilayah baru'; ?></p>
                            </div>
                            <button class="modal-close" onclick="closeModal('modalTambahWilayah')">
                                <i class="fas fa-times"></i>
                            </button>
                        </div>
                        <form method="POST" action="dashboard.php?tab=wilayah" id="formWilayah">
                            <?php if ($editWilayah): ?>
                                <input type="hidden" name="id" value="<?php echo $editWilayah['id']; ?>">
                                <div class="modal-body">
                                    <div class="form-group">
                                        <label class="form-label" for="desa">Desa</label>
                                        <input type="text" id="desa" name="desa" class="form-control" value="<?php echo htmlspecialchars($editWilayah['desa']); ?>" placeholder="Contoh: Desa Makmur" required>
                                    </div>
                                    <div class="form-group">
                                        <label class="form-label" for="kecamatan">Kecamatan</label>
                                        <input type="text" id="kecamatan" name="kecamatan" class="form-control" value="<?php echo htmlspecialchars($editWilayah['kecamatan']); ?>" placeholder="Contoh: Kecamatan Sejahtera" required>
                                    </div>
                                    <div class="form-group">
                                        <label class="form-label" for="kabupaten">Kabupaten</label>
                                        <input type="text" id="kabupaten" name="kabupaten" class="form-control" value="<?php echo htmlspecialchars($editWilayah['kabupaten']); ?>" placeholder="Contoh: Kabupaten Jaya" required>
                                    </div>
                                </div>
                            <?php else: ?>
                                <input type="hidden" name="is_bulk" value="1">
                                <input type="hidden" name="bulk_data" id="bulk_data">
                                <div class="modal-body">
                                    <div class="form-group">
                                        <label class="form-label" for="kabupaten">Kabupaten</label>
                                        <input type="text" id="kabupaten" name="kabupaten" class="form-control" placeholder="Contoh: Kabupaten Jaya" list="kabupaten_list" required>
                                        <datalist id="kabupaten_list">
                                            <?php 
                                            $unique_kab = array_unique(array_column($wilayah, 'kabupaten'));
                                            foreach ($unique_kab as $kab) {
                                                echo '<option value="' . htmlspecialchars($kab) . '">';
                                            }
                                            ?>
                                        </datalist>
                                    </div>
                                    
                                    <div id="kecamatan_container">
                                        <!-- Kecamatan items will be added here -->
                                    </div>

                                    <button type="button" class="btn btn-secondary btn-sm" onclick="addKecamatan()" style="margin-top: 10px;">
                                        <i class="fas fa-plus"></i> Tambah Kecamatan
                                    </button>
                                </div>
                            <?php endif; ?>
                            <div class="modal-footer">
                                <button type="submit" class="btn btn-primary">Simpan</button>
                                <button type="button" class="btn btn-secondary" onclick="closeModal('modalTambahWilayah')">Batal</button>
                            </div>
                        </form>
                    </div>
                </div>

                <?php if ($editWilayah): ?>
                    <script>
                        document.addEventListener('DOMContentLoaded', function() {
                            openModal('modalTambahWilayah');
                        });
                    </script>
                <?php else: ?>
                    <script>
                        function addKecamatan() {
                            const container = document.getElementById('kecamatan_container');
                            const id = Date.now();
                            const html = `
                                <div class="kecamatan-item" id="kec_${id}" style="border: 1px solid #ddd; padding: 15px; margin-top: 15px; border-radius: 8px; background: #f9f9f9;">
                                    <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 10px;">
                                        <h4 style="margin: 0; font-size: 14px; color: var(--primary-color);">Data Kecamatan</h4>
                                        <button type="button" class="btn btn-danger btn-sm" onclick="removeElement('kec_${id}')" style="padding: 2px 8px;">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </div>
                                    <div class="form-group">
                                        <input type="text" class="form-control kec-name" placeholder="Nama Kecamatan" required>
                                    </div>
                                    <div class="desa-container" id="desa_container_${id}" style="margin-left: 20px; border-left: 2px solid #ddd; padding-left: 15px;">
                                        <!-- Desa items -->
                                    </div>
                                    <button type="button" class="btn btn-success btn-sm" onclick="addDesa('${id}')" style="margin-top: 10px; font-size: 12px;">
                                        <i class="fas fa-plus"></i> Tambah Desa
                                    </button>
                                </div>
                            `;
                            container.insertAdjacentHTML('beforeend', html);
                            addDesa(id);
                        }

                        function addDesa(kecId) {
                            const container = document.getElementById(`desa_container_${kecId}`);
                            const id = Date.now() + Math.random().toString(16).slice(2);
                            const html = `
                                <div class="desa-item" id="desa_${id}" style="display: flex; gap: 10px; margin-top: 5px;">
                                    <input type="text" class="form-control desa-name" placeholder="Nama Desa" required>
                                    <button type="button" class="btn btn-danger btn-sm" onclick="removeElement('desa_${id}')">
                                        <i class="fas fa-times"></i>
                                    </button>
                                </div>
                            `;
                            container.insertAdjacentHTML('beforeend', html);
                        }

                        function removeElement(id) {
                            document.getElementById(id).remove();
                        }

                        document.getElementById('formWilayah').addEventListener('submit', function(e) {
                            if (document.querySelector('[name="is_bulk"]')) {
                                e.preventDefault();
                                
                                const kabupaten = document.getElementById('kabupaten').value;
                                const data = [];
                                
                                document.querySelectorAll('.kecamatan-item').forEach(kecItem => {
                                    const kecamatan = kecItem.querySelector('.kec-name').value;
                                    const desas = [];
                                    kecItem.querySelectorAll('.desa-name').forEach(desaItem => {
                                        if (desaItem.value.trim()) {
                                            desas.push(desaItem.value.trim());
                                        }
                                    });
                                    
                                    if (kecamatan && desas.length > 0) {
                                        data.push({
                                            kecamatan: kecamatan,
                                            desas: desas
                                        });
                                    }
                                });

                                if (data.length === 0) {
                                    alert('Mohon isi minimal satu kecamatan dan desa');
                                    return;
                                }

                                document.getElementById('bulk_data').value = JSON.stringify(data);
                                this.submit();
                            }
                        });

                        document.addEventListener('DOMContentLoaded', function() {
                            addKecamatan();
                        });
                    </script>
                <?php endif; ?>
                <?php endif; ?>