                <div class="card">
                    <div class="card-header">
                        <div>
                            <h2 class="card-title">Daftar Komoditi</h2>
                            <p class="card-subtitle">Total: <?php echo count($tanaman); ?> jenis tanaman</p>
                        </div>
                        <?php if ($isAdmin || $isPetugas): ?>
                        <button class="btn btn-primary" onclick="openModal('modalTambahTanaman')">
                            <i class="fas fa-plus"></i>
                            Tambah Komoditi
                        </button>
                        <?php endif; ?>
                    </div>

                    <div class="table-container">
                        <table>
                            <thead>
                                <tr>
                                    <th>Nama Komoditi</th>
                                    <th>Jenis Komoditi</th>
                                    <th>Satuan Produksi</th>
                                    <?php if ($isAdmin || $isPetugas): ?>
                                    <th>Aksi</th>
                                    <?php endif; ?>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if (empty($tanaman)): ?>
                                    <tr>
                                        <td colspan="<?php echo ($isAdmin || $isPetugas) ? 4 : 3; ?>" style="text-align: center; padding: 40px; color: var(--text-light);">
                                            Tidak ada data tanaman
                                        </td>
                                    </tr>
                                <?php else: ?>
                                    <?php foreach ($tanaman as $t): ?>
                                        <tr>
                                            <td><?php echo htmlspecialchars($t['nama_tanaman']); ?></td>
                                            <td><?php echo htmlspecialchars($t['jenis_tanaman']); ?></td>
                                            <td><?php echo htmlspecialchars($t['satuan_produksi']); ?></td>
                                            <?php if ($isAdmin || $isPetugas): ?>
                                            <td>
                                                <div class="action-buttons">
                                                    <a href="dashboard.php?tab=tanaman&edit=<?php echo $t['id']; ?>" class="action-btn edit">
                                                        <i class="fas fa-edit"></i>
                                                    </a>
                                                    <a href="dashboard.php?tab=tanaman&delete=<?php echo $t['id']; ?>" class="action-btn delete" onclick="return confirmDelete('Apakah Anda yakin ingin menghapus tanaman ini?')">
                                                        <i class="fas fa-trash"></i>
                                                    </a>
                                                </div>
                                            </td>
                                            <?php endif; ?>
                                        </tr>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            </tbody>
                        </table>

                        <!-- Pagination -->
                        <?php if (isset($totalRows) && $totalRows > 0): ?>
                        <div style="margin-top: 20px; display: flex; justify-content: space-between; align-items: center; padding: 0 10px;">
                            <div style="font-size: 0.9em; color: #666;">
                                Menampilkan <?php echo count($tanaman); ?> dari <?php echo $totalRows; ?> data
                            </div>
                            <div class="pagination" style="display: flex; gap: 5px; align-items: center;">
                                <?php if ($page > 1): ?>
                                    <a href="dashboard.php?tab=tanaman&page=<?php echo $page - 1; ?>" class="btn btn-sm btn-secondary" style="padding: 5px 10px; font-size: 12px;">&laquo; Prev</a>
                                <?php endif; ?>
                                
                                <span style="padding: 5px 10px; background: #f1f1f1; border-radius: 4px; font-size: 0.9em;">Halaman <?php echo $page; ?> dari <?php echo $totalPages; ?></span>

                                <?php if ($page < $totalPages): ?>
                                    <a href="dashboard.php?tab=tanaman&page=<?php echo $page + 1; ?>" class="btn btn-sm btn-secondary" style="padding: 5px 10px; font-size: 12px;">Next &raquo;</a>
                                <?php endif; ?>
                            </div>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>

                <!-- Modal Tambah/Edit Tanaman -->
                <?php if ($isAdmin || $isPetugas): ?>
                <div id="modalTambahTanaman" class="modal-overlay">
                    <div class="modal">
                        <div class="modal-header">
                            <div>
                                <h3 class="modal-title"><?php echo $editTanaman ? 'Edit Tanaman' : 'Tambah Komoditi'; ?></h3>
                                <p class="modal-subtitle"><?php echo $editTanaman ? 'Edit jenis tanaman' : 'Tambahkan jenis Komoditi baru'; ?></p>
                            </div>
                            <button class="modal-close" onclick="closeModal('modalTambahTanaman')">
                                <i class="fas fa-times"></i>
                            </button>
                        </div>
                        <form method="POST" action="dashboard.php?tab=tanaman" id="formTanaman">
                            <?php if ($editTanaman): ?>
                                <input type="hidden" name="id" value="<?php echo $editTanaman['id']; ?>">
                            <?php endif; ?>
                            <div class="modal-body">
                                <div class="form-group">
                                    <label class="form-label" for="nama_tanaman">Nama Komoditi</label>
                                    <input type="text" id="nama_tanaman" name="nama_tanaman" class="form-control" value="<?php echo $editTanaman ? htmlspecialchars($editTanaman['nama_tanaman']) : ''; ?>" placeholder="Contoh: Kelapa Sawit" required>
                                </div>

                                <div class="form-group">
                                    <label class="form-label" for="jenis_tanaman">Jenis Komoditi</label>
                                    <select id="jenis_tanaman" name="jenis_tanaman" class="form-control" required>
                                        <option value="">Pilih Jenis Komoditi</option>
                                        <option value="Tanaman Perkebunan" <?php echo ($editTanaman && $editTanaman['jenis_tanaman'] == 'Tanaman Perkebunan') ? 'selected' : ''; ?>>Komoditi Perkebunan</option>
                                    </select>
                                </div>
                             
                                <div class="form-group">
                                    <label class="form-label" for="satuan_produksi">Satuan Produksi</label>
                                    <input type="text" id="satuan_produksi" name="satuan_produksi" class="form-control" value="<?php echo $editTanaman ? htmlspecialchars($editTanaman['satuan_produksi']) : ''; ?>" placeholder="Contoh: Ton" required>
                                </div>
                            </div>
                            <div class="modal-footer">
                                <button type="submit" class="btn btn-primary">Simpan</button>
                                <button type="button" class="btn btn-secondary" onclick="closeModal('modalTambahTanaman')">Batal</button>
                            </div>
                        </form>
                    </div>
                </div>

                <?php if ($editTanaman): ?>
                    <script>
                        document.addEventListener('DOMContentLoaded', function() {
                            openModal('modalTambahTanaman');
                        });
                    </script>
                <?php endif; ?>
                <?php endif; ?>