                <div class="card">
                    <div class="card-header">
                        <div>
                            <h2 class="card-title">Daftar Pengguna</h2>
                            <p class="card-subtitle">Total: <?php echo count($users); ?> pengguna</p>
                        </div>
                        <button class="btn btn-primary" onclick="openModal('modalTambahPengguna')">
                            <i class="fas fa-plus"></i>
                            Tambah Pengguna
                        </button>
                    </div>

                    <div class="table-container">
                        <table>
                            <thead>
                                <tr>
                                    <th>Username</th>
                                    <th>Nama</th>
                                    <th>Email</th>
                                    <th>Jenis Kelamin</th>
                                    <th>Jabatan</th>
                                    <th>Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if (empty($users)): ?>
                                    <tr>
                                        <td colspan="6" style="text-align: center; padding: 40px; color: var(--text-light);">
                                            Tidak ada data pengguna
                                        </td>
                                    </tr>
                                <?php else: ?>
                                    <?php foreach ($users as $user): ?>
                                        <tr>
                                            <td><?php echo htmlspecialchars($user['username']); ?></td>
                                            <td><?php echo htmlspecialchars($user['nama_lengkap']); ?></td>
                                            <td><?php echo htmlspecialchars($user['email']); ?></td>
                                            <td><?php echo htmlspecialchars($user['jenis_kelamin']); ?></td>
                                            <td>
                                                <span class="badge badge-primary"><?php echo htmlspecialchars($user['jabatan']); ?></span>
                                            </td>
                                            <td>
                                                <div class="action-buttons">
                                                    <a href="dashboard.php?tab=pengguna&edit=<?php echo $user['id']; ?>" class="action-btn edit" onclick="openModal('modalTambahPengguna'); return false;">
                                                        <i class="fas fa-edit"></i>
                                                    </a>
                                                    <?php if ($user['id'] != $_SESSION['user_id']): ?>
                                                        <a href="dashboard.php?tab=pengguna&delete=<?php echo $user['id']; ?>" class="action-btn delete" onclick="return confirmDelete('Apakah Anda yakin ingin menghapus pengguna ini?')">
                                                            <i class="fas fa-trash"></i>
                                                        </a>
                                                    <?php endif; ?>
                                                </div>
                                            </td>
                                        </tr>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>

                <!-- Modal Tambah/Edit Pengguna -->
                <div id="modalTambahPengguna" class="modal-overlay">
                    <div class="modal">
                        <div class="modal-header">
                            <div>
                                <h3 class="modal-title"><?php echo $editUser ? 'Edit Pengguna' : 'Tambah Pengguna'; ?></h3>
                                <p class="modal-subtitle"><?php echo $editUser ? 'Edit data pengguna' : 'Tambahkan pengguna baru'; ?></p>
                            </div>
                            <button class="modal-close" onclick="closeModal('modalTambahPengguna')">
                                <i class="fas fa-times"></i>
                            </button>
                        </div>
                        <form method="POST" action="dashboard.php?tab=pengguna" id="formPengguna">
                            <?php if ($editUser): ?>
                                <input type="hidden" name="id" value="<?php echo $editUser['id']; ?>">
                            <?php endif; ?>
                            <div class="modal-body">
                                <div class="form-group">
                                    <label class="form-label" for="username">Username</label>
                                    <input type="text" id="username" name="username" class="form-control" value="<?php echo $editUser ? htmlspecialchars($editUser['username']) : ''; ?>" required>
                                </div>
                                <?php if (!$editUser): ?>
                                    <div class="form-group">
                                        <label class="form-label" for="password">Password</label>
                                        <input type="password" id="password" name="password" class="form-control" required>
                                    </div>
                                <?php else: ?>
                                    <div class="form-group">
                                        <label class="form-label" for="password">Password (kosongkan jika tidak ingin mengubah)</label>
                                        <input type="password" id="password" name="password" class="form-control">
                                    </div>
                                <?php endif; ?>
                                <div class="form-group">
                                    <label class="form-label" for="nama_lengkap">Nama Lengkap</label>
                                    <input type="text" id="nama_lengkap" name="nama_lengkap" class="form-control" value="<?php echo $editUser ? htmlspecialchars($editUser['nama_lengkap']) : ''; ?>" required>
                                </div>
                                <div class="form-group">
                                    <label class="form-label" for="email">Email</label>
                                    <input type="email" id="email" name="email" class="form-control" value="<?php echo $editUser ? htmlspecialchars($editUser['email']) : ''; ?>" required>
                                </div>
                                <div class="form-group">
                                    <label class="form-label" for="jenis_kelamin">Jenis Kelamin</label>
                                    <select id="jenis_kelamin" name="jenis_kelamin" class="form-control" required>
                                        <option value="">Pilih jenis kelamin</option>
                                        <option value="Laki-laki" <?php echo ($editUser && $editUser['jenis_kelamin'] == 'Laki-laki') ? 'selected' : ''; ?>>Laki-laki</option>
                                        <option value="Perempuan" <?php echo ($editUser && $editUser['jenis_kelamin'] == 'Perempuan') ? 'selected' : ''; ?>>Perempuan</option>
                                    </select>
                                </div>
                                <div class="form-group">
                                    <label class="form-label" for="jabatan">Jabatan</label>
                                    <select id="jabatan" name="jabatan" class="form-control" required>
                                        <option value="">Pilih jabatan</option>
                                        <option value="Admin" <?php echo ($editUser && $editUser['jabatan'] == 'Admin') ? 'selected' : ''; ?>>Admin</option>
                                        <option value="Petugas Lapangan" <?php echo ($editUser && $editUser['jabatan'] == 'Petugas Lapangan') ? 'selected' : ''; ?>>Petugas Lapangan</option>
                                        <option value="Pegawai" <?php echo ($editUser && $editUser['jabatan'] == 'Pegawai') ? 'selected' : ''; ?>>Pegawai</option>
                                    </select>
                                </div>
                            </div>
                            <div class="modal-footer">
                                <button type="submit" class="btn btn-primary">Simpan</button>
                                <button type="button" class="btn btn-secondary" onclick="closeModal('modalTambahPengguna')">Batal</button>
                            </div>
                        </form>
                    </div>
                </div>

                <?php if ($editUser): ?>
                    <script>
                        document.addEventListener('DOMContentLoaded', function() {
                            openModal('modalTambahPengguna');
                        });
                    </script>
                <?php endif; ?>