<?php
// Logic for Wilayah Tab
if ($activeTab == 'wilayah') {
    // Admin and Petugas can manage wilayah
    if (!($isAdmin || $isPetugas) && $_SERVER['REQUEST_METHOD'] == 'POST') {
        header('Location: dashboard.php?tab=wilayah');
        exit();
    }
    if (!($isAdmin || $isPetugas) && isset($_GET['delete'])) {
         header('Location: dashboard.php?tab=wilayah');
         exit();
    }

    // Handle delete
    if (isset($_GET['delete']) && is_numeric($_GET['delete'])) {
        $id = intval($_GET['delete']);
        $stmt = $conn->prepare("DELETE FROM wilayah WHERE id = ?");
        $stmt->bind_param("i", $id);
        $stmt->execute();
        $stmt->close();
        header('Location: dashboard.php?tab=wilayah&success=delete');
        exit();
    }

    // Handle add/edit
    if ($_SERVER['REQUEST_METHOD'] == 'POST') {
        $id = $_POST['id'] ?? null;
        
        // Check if bulk insert
        if (isset($_POST['is_bulk']) && isset($_POST['bulk_data'])) {
            $kabupaten = $_POST['kabupaten'] ?? '';
            $bulk_data = json_decode($_POST['bulk_data'], true);
            
            if ($kabupaten && is_array($bulk_data)) {
                $stmt = $conn->prepare("INSERT INTO wilayah (desa, kecamatan, kabupaten) VALUES (?, ?, ?)");
                
                foreach ($bulk_data as $kec_data) {
                    $kecamatan = $kec_data['kecamatan'];
                    foreach ($kec_data['desas'] as $desa) {
                        // Check if exists to prevent duplicates (optional but good practice)
                        $check = $conn->query("SELECT id FROM wilayah WHERE desa = '$desa' AND kecamatan = '$kecamatan' AND kabupaten = '$kabupaten'");
                        if ($check->num_rows == 0) {
                            $stmt->bind_param("sss", $desa, $kecamatan, $kabupaten);
                            $stmt->execute();
                        }
                    }
                }
                $stmt->close();
                header('Location: dashboard.php?tab=wilayah&success=add');
                exit();
            }
        }

        $desa = $_POST['desa'] ?? '';
        $kecamatan = $_POST['kecamatan'] ?? '';
        $kabupaten = $_POST['kabupaten'] ?? '';

        if ($desa && $kecamatan && $kabupaten) {
            if ($id) {
                // Update
                $stmt = $conn->prepare("UPDATE wilayah SET desa = ?, kecamatan = ?, kabupaten = ? WHERE id = ?");
                $stmt->bind_param("sssi", $desa, $kecamatan, $kabupaten, $id);
            } else {
                // Insert
                $stmt = $conn->prepare("INSERT INTO wilayah (desa, kecamatan, kabupaten) VALUES (?, ?, ?)");
                $stmt->bind_param("sss", $desa, $kecamatan, $kabupaten);
            }
            $stmt->execute();
            $stmt->close();
            header('Location: dashboard.php?tab=wilayah&success=' . ($id ? 'update' : 'add'));
            exit();
        }
    }

    // Pagination logic
    $page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
    $limit = 10;
    $offset = ($page - 1) * $limit;

    // Get total rows
    $totalResult = $conn->query("SELECT COUNT(*) as count FROM wilayah");
    $totalRows = $totalResult->fetch_assoc()['count'];
    $totalPages = ceil($totalRows / $limit);

    // Get regions with pagination
    $stmt = $conn->prepare("SELECT * FROM wilayah ORDER BY id DESC LIMIT ? OFFSET ?");
    $stmt->bind_param("ii", $limit, $offset);
    $stmt->execute();
    $result = $stmt->get_result();
    $wilayah = [];
    while ($row = $result->fetch_assoc()) {
        $wilayah[] = $row;
    }
    $stmt->close();

    // Get region for edit
    $editWilayah = null;
    if (isset($_GET['edit']) && is_numeric($_GET['edit'])) {
        if (!($isAdmin || $isPetugas)) {
             header('Location: dashboard.php?tab=wilayah');
             exit();
        }
        $editId = intval($_GET['edit']);
        $stmt = $conn->prepare("SELECT * FROM wilayah WHERE id = ?");
        $stmt->bind_param("i", $editId);
        $stmt->execute();
        $result = $stmt->get_result();
        if ($result->num_rows > 0) {
            $editWilayah = $result->fetch_assoc();
        }
        $stmt->close();
    }
}
?>