<?php
// Logic for Tanaman Tab
if ($activeTab == 'tanaman') {
    // Admin and Petugas can manage tanaman
    if (!($isAdmin || $isPetugas) && $_SERVER['REQUEST_METHOD'] == 'POST') {
        // Prevent unauthorized posting
        header('Location: dashboard.php?tab=tanaman');
        exit();
    }
    if (!($isAdmin || $isPetugas) && isset($_GET['delete'])) {
         header('Location: dashboard.php?tab=tanaman');
         exit();
    }

    // Handle delete
    if (isset($_GET['delete']) && is_numeric($_GET['delete'])) {
        $id = intval($_GET['delete']);
        $stmt = $conn->prepare("DELETE FROM tanaman WHERE id = ?");
        $stmt->bind_param("i", $id);
        $stmt->execute();
        $stmt->close();
        header('Location: dashboard.php?tab=tanaman&success=delete');
        exit();
    }

    // Handle add/edit
    if ($_SERVER['REQUEST_METHOD'] == 'POST') {
        $id = $_POST['id'] ?? null;
        $nama_tanaman = $_POST['nama_tanaman'] ?? '';
        $jenis_tanaman = $_POST['jenis_tanaman'] ?? '';
        $satuan_produksi = $_POST['satuan_produksi'] ?? '';

        if ($nama_tanaman && $jenis_tanaman && $satuan_produksi) {
            if ($id) {
                // Update
                $stmt = $conn->prepare("UPDATE tanaman SET nama_tanaman = ?, jenis_tanaman = ?, satuan_produksi = ? WHERE id = ?");
                $stmt->bind_param("sssi", $nama_tanaman, $jenis_tanaman, $satuan_produksi, $id);
            } else {
                // Insert
                $stmt = $conn->prepare("INSERT INTO tanaman (nama_tanaman, jenis_tanaman, satuan_produksi) VALUES (?, ?, ?)");
                $stmt->bind_param("sss", $nama_tanaman, $jenis_tanaman, $satuan_produksi);
            }
            $stmt->execute();
            $stmt->close();
            header('Location: dashboard.php?tab=tanaman&success=' . ($id ? 'update' : 'add'));
            exit();
        }
    }

    // Pagination logic
    $page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
    $limit = 10;
    $offset = ($page - 1) * $limit;

    // Get total rows
    $totalResult = $conn->query("SELECT COUNT(*) as count FROM tanaman");
    $totalRows = $totalResult->fetch_assoc()['count'];
    $totalPages = ceil($totalRows / $limit);

    // Get plants with pagination
    $stmt = $conn->prepare("SELECT * FROM tanaman ORDER BY id DESC LIMIT ? OFFSET ?");
    $stmt->bind_param("ii", $limit, $offset);
    $stmt->execute();
    $result = $stmt->get_result();
    $tanaman = [];
    while ($row = $result->fetch_assoc()) {
        $tanaman[] = $row;
    }
    $stmt->close();

    // Get plant for edit
    $editTanaman = null;
    if (isset($_GET['edit']) && is_numeric($_GET['edit'])) {
        if (!($isAdmin || $isPetugas)) {
             header('Location: dashboard.php?tab=tanaman'); // Prevent edit form for unauthorized
             exit();
        }
        $editId = intval($_GET['edit']);
        $stmt = $conn->prepare("SELECT * FROM tanaman WHERE id = ?");
        $stmt->bind_param("i", $editId);
        $stmt->execute();
        $result = $stmt->get_result();
        if ($result->num_rows > 0) {
            $editTanaman = $result->fetch_assoc();
        }
        $stmt->close();
    }
}
?>