<?php
// Logic for Pengguna Tab
if ($activeTab == 'pengguna') {
    // Only Admin can manage users
    if (!$isAdmin) {
        header('Location: dashboard.php');
        exit();
    }

    // Handle delete
    if (isset($_GET['delete']) && is_numeric($_GET['delete'])) {
        $id = intval($_GET['delete']);
        if ($id != $_SESSION['user_id']) {
            $stmt = $conn->prepare("DELETE FROM users WHERE id = ?");
            $stmt->bind_param("i", $id);
            $stmt->execute();
            $stmt->close();
            header('Location: dashboard.php?tab=pengguna&success=delete');
            exit();
        }
    }

    // Handle add/edit
    if ($_SERVER['REQUEST_METHOD'] == 'POST') {
        $id = $_POST['id'] ?? null;
        $username = $_POST['username'] ?? '';
        $password = $_POST['password'] ?? '';
        $nama_lengkap = $_POST['nama_lengkap'] ?? '';
        $email = $_POST['email'] ?? '';
        $jenis_kelamin = $_POST['jenis_kelamin'] ?? '';
        $jabatan = $_POST['jabatan'] ?? '';

        if ($username && $nama_lengkap && $email && $jenis_kelamin && $jabatan) {
            if ($id) {
                // Update
                if ($password) {
                    $hashed_password = password_hash($password, PASSWORD_DEFAULT);
                    $stmt = $conn->prepare("UPDATE users SET username = ?, password = ?, nama_lengkap = ?, email = ?, jenis_kelamin = ?, jabatan = ? WHERE id = ?");
                    $stmt->bind_param("ssssssi", $username, $hashed_password, $nama_lengkap, $email, $jenis_kelamin, $jabatan, $id);
                } else {
                    $stmt = $conn->prepare("UPDATE users SET username = ?, nama_lengkap = ?, email = ?, jenis_kelamin = ?, jabatan = ? WHERE id = ?");
                    $stmt->bind_param("sssssi", $username, $nama_lengkap, $email, $jenis_kelamin, $jabatan, $id);
                }
                $stmt->execute();
                $stmt->close();
                header('Location: dashboard.php?tab=pengguna&success=update');
            } else {
                // Insert
                $hashed_password = password_hash($password, PASSWORD_DEFAULT);
                $stmt = $conn->prepare("INSERT INTO users (username, password, nama_lengkap, email, jenis_kelamin, jabatan) VALUES (?, ?, ?, ?, ?, ?)");
                $stmt->bind_param("ssssss", $username, $hashed_password, $nama_lengkap, $email, $jenis_kelamin, $jabatan);
                $stmt->execute();
                $stmt->close();
                header('Location: dashboard.php?tab=pengguna&success=add');
            }
            exit();
        }
    }

    // Get all users
    $result = $conn->query("SELECT * FROM users ORDER BY id DESC");
    $users = [];
    while ($row = $result->fetch_assoc()) {
        $users[] = $row;
    }

    // Get user for edit
    $editUser = null;
    if (isset($_GET['edit']) && is_numeric($_GET['edit'])) {
        $editId = intval($_GET['edit']);
        $stmt = $conn->prepare("SELECT * FROM users WHERE id = ?");
        $stmt->bind_param("i", $editId);
        $stmt->execute();
        $result = $stmt->get_result();
        if ($result->num_rows > 0) {
            $editUser = $result->fetch_assoc();
        }
        $stmt->close();
    }
}
?>